/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.cdres.serialize;

import java.io.IOException;
import java.io.Writer;
import org.milyn.cdr.SmooksResourceConfiguration;
import org.milyn.container.ContainerRequest;
import org.milyn.delivery.serialize.DefaultSerializationUnit;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class EmptyElementSU
extends DefaultSerializationUnit {
    private boolean wellFormed = true;

    public EmptyElementSU(SmooksResourceConfiguration resourceConfig) {
        super(resourceConfig);
        this.wellFormed = resourceConfig.getBoolParameter("wellFormed", true);
    }

    public void writeElementStart(Element element, Writer writer, ContainerRequest containerRequest) throws IOException {
        writer.write(60);
        writer.write(element.getTagName());
        this.writeAttributes(element.getAttributes(), writer);
    }

    public void writeElementEnd(Element element, Writer writer, ContainerRequest containerRequest) throws IOException {
        if (this.wellFormed) {
            writer.write("/>");
        } else {
            writer.write(62);
        }
    }

    public void writeElementText(Text text, Writer writer, ContainerRequest containerRequest) throws IOException {
    }

    public void writeElementComment(Comment comment, Writer writer, ContainerRequest containerRequest) throws IOException {
    }

    public void writeElementEntityRef(EntityReference entityRef, Writer writer, ContainerRequest containerRequest) throws IOException {
    }

    public void writeElementCDATA(CDATASection cdata, Writer writer, ContainerRequest containerRequest) throws IOException {
    }

    public void writeElementNode(Node node, Writer writer, ContainerRequest containerRequest) throws IOException {
    }

    public String getShortDescription() {
        return "Write empty elements";
    }

    public String getDetailDescription() {
        return "Writes empty elements well-formed (<xxx/>) or badly-formed (<xxx>).  Ensures that any child content is not writen.";
    }

    public boolean writeChildElements() {
        return false;
    }
}

