/*
 * JMockit Expectations
 * Copyright (c) 2006-2010 Rogério Liesenfeld
 * All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
 * CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
package mockit.internal.expectations.mocking;

import java.lang.reflect.*;
import java.util.*;

import mockit.internal.state.*;
import mockit.internal.util.*;

public final class LocalFieldTypeRedefinitions extends FieldTypeRedefinitions
{
   private Map<Type, Object> typesAndTargetObjects;

   public LocalFieldTypeRedefinitions(Object objectWithMockFields)
   {
      super(objectWithMockFields);
      typesAndTargetObjects = new HashMap<Type, Object>(2);
   }

   public void redefineTypesForNestedClass(Map<Type, Object> typesAndTargetObjects)
   {
      this.typesAndTargetObjects = typesAndTargetObjects;
      redefineFieldTypes(parentObject.getClass(), false);
      this.typesAndTargetObjects = null;
   }

   @Override
   protected TypeRedefinition redefineTypeForMockField()
   {
      TypeRedefinition typeRedefinition = new TypeRedefinition(parentObject, typeMetadata);

      if (finalField) {
         typeRedefinition.redefineTypeForFinalField();
      }
      else {
         Object mock = typeRedefinition.redefineType();
         Utilities.setFieldValue(field, parentObject, mock);

         if (typeMetadata.nonStrict) {
            // TODO: in a NonStrictExpectations block this is redundant, so it can be optimized away
            TestRun.getExecutingTest().addNonStrictMock(mock);
         }
      }

      typesAndTargetObjects.put(typeMetadata.declaredType, parentObject);
      targetClasses.add(typeRedefinition.targetClass);
      
      return typeRedefinition;
   }

   @Override
   public boolean captureNewInstanceForApplicableMockField(Object mock)
   {
      return
         captureOfNewInstances != null &&
         getCaptureOfNewInstances().captureNewInstanceForApplicableMockField(parentObject, mock);
   }
}
