/*
 * Decompiled with CFR 0.152.
 */
package org.distributeme.support.eventservice;

import java.io.IOException;
import java.io.Serializable;
import java.util.concurrent.CopyOnWriteArrayList;
import net.anotheria.anoprise.eventservice.Event;
import net.anotheria.anoprise.eventservice.EventServiceConsumer;
import net.anotheria.anoprise.eventservice.EventTransportShell;
import net.anotheria.anoprise.eventservice.RemoteEventChannelConsumerProxy;
import net.anotheria.anoprise.eventservice.RemoteEventServiceConsumer;
import net.anotheria.net.util.ByteArraySerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiMeRemoteEventChannelConsumerProxy
implements RemoteEventChannelConsumerProxy {
    private static Logger LOG = LoggerFactory.getLogger(DiMeRemoteEventChannelConsumerProxy.class);
    private CopyOnWriteArrayList<RemoteEventServiceConsumer> consumers = new CopyOnWriteArrayList();
    private String channelName;

    DiMeRemoteEventChannelConsumerProxy(String aChannelName) {
        this.channelName = aChannelName;
    }

    public void addRemoteConsumer(RemoteEventServiceConsumer consumer) {
        this.consumers.add(consumer);
    }

    public void removeRemoteConsumer(RemoteEventServiceConsumer consumer) {
        this.consumers.remove(consumer);
    }

    public void addConsumer(EventServiceConsumer consumer) {
        throw new UnsupportedOperationException("addConsumer");
    }

    public String getName() {
        return this.channelName;
    }

    public void push(Event e) {
        throw new UnsupportedOperationException("addConsumer");
    }

    public void removeConsumer(EventServiceConsumer consumer) {
        throw new UnsupportedOperationException("addConsumer");
    }

    public void pushEvent(Event e) {
        EventTransportShell shell = new EventTransportShell();
        shell.setChannelName(this.getName());
        try {
            shell.setData(ByteArraySerializer.serializeObject((Serializable)e));
        }
        catch (IOException ex) {
            LOG.error("Can't serialize event data, aborting event", (Throwable)ex);
            throw new IllegalArgumentException("Event " + e + " contains not serializeable data part", ex);
        }
        for (RemoteEventServiceConsumer consumer : this.consumers) {
            try {
                consumer.deliverEvent(shell);
            }
            catch (Exception ex) {
                LOG.warn("Consumer " + consumer + " failed, skipping", (Throwable)ex);
            }
        }
    }

    public boolean isLocal() {
        return false;
    }
}

