/*
 * Decompiled with CFR 0.152.
 */
package org.distributeme.support.eventservice;

import java.io.IOException;
import java.util.concurrent.CopyOnWriteArrayList;
import net.anotheria.anoprise.eventservice.Event;
import net.anotheria.anoprise.eventservice.EventChannelConsumerProxy;
import net.anotheria.anoprise.eventservice.EventServiceConsumer;
import net.anotheria.anoprise.eventservice.RemoteEventChannelSupplierProxy;
import net.anotheria.net.util.ByteArraySerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiMeRemoteEventChannelSupplierProxy
implements RemoteEventChannelSupplierProxy {
    private String channelName;
    private CopyOnWriteArrayList<EventChannelConsumerProxy> consumerProxies = new CopyOnWriteArrayList();
    private static Logger log = LoggerFactory.getLogger(DiMeRemoteEventChannelSupplierProxy.class);

    DiMeRemoteEventChannelSupplierProxy(String aChannelName) {
        this.channelName = aChannelName;
    }

    public void deliverEvent(byte[] eventData) {
        Event event = null;
        try {
            event = (Event)ByteArraySerializer.deserializeObject((byte[])eventData);
        }
        catch (IOException e) {
            log.warn("Couldn't deserialize event data, throwing away. ", (Throwable)e);
            return;
        }
        if (event.isNonExistent()) {
            return;
        }
        this.push(event);
    }

    public void addConsumer(EventServiceConsumer consumer) {
        throw new UnsupportedOperationException("addConsumer");
    }

    public String getName() {
        return this.channelName;
    }

    public void push(Event e) {
        for (EventChannelConsumerProxy proxy : this.consumerProxies) {
            if (!proxy.isLocal()) continue;
            proxy.pushEvent(e);
        }
    }

    public void removeConsumer(EventServiceConsumer consumer) {
        throw new UnsupportedOperationException("removeConsumer");
    }

    public void addConsumerProxy(EventChannelConsumerProxy proxy) {
        this.consumerProxies.add(proxy);
    }

    public void removeConsumerProxy(EventChannelConsumerProxy proxy) {
        this.consumerProxies.remove(proxy);
    }

    public boolean isLocal() {
        return false;
    }
}

