/*
 * Decompiled with CFR 0.152.
 */
package org.distributeme.support.eventservice;

import java.util.concurrent.atomic.AtomicInteger;
import net.anotheria.anoprise.eventservice.EventTransportShell;
import net.anotheria.anoprise.eventservice.RemoteEventServiceConsumer;
import org.distributeme.core.ServiceDescriptor;
import org.distributeme.support.eventservice.DiMeRemoteEventChannelRMISupport;
import org.distributeme.support.eventservice.EventServiceRMIBridgeService;
import org.distributeme.support.eventservice.EventServiceRMIBridgeServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteConsumerWrapper
implements RemoteEventServiceConsumer {
    public static final int ERROR_LIMIT = 5;
    private static Logger LOG = LoggerFactory.getLogger(RemoteConsumerWrapper.class);
    private String channelName;
    private DiMeRemoteEventChannelRMISupport support;
    private ServiceDescriptor myHomeReference;
    private EventServiceRMIBridgeService bridgeToHome;
    private AtomicInteger errorCount = new AtomicInteger(0);

    public RemoteConsumerWrapper(DiMeRemoteEventChannelRMISupport aSupport, String aChannelName, ServiceDescriptor aHomeReference, EventServiceRMIBridgeService aBridgeToHome) {
        this.myHomeReference = aHomeReference;
        this.bridgeToHome = aBridgeToHome;
        this.support = aSupport;
        this.channelName = aChannelName;
    }

    public void deliverEvent(EventTransportShell event) {
        LOG.debug("Sending event " + event + " home; " + this.myHomeReference);
        try {
            this.bridgeToHome.deliverEvent(event);
            this.errorCount.set(0);
        }
        catch (EventServiceRMIBridgeServiceException e) {
            this.handleError();
        }
        catch (RuntimeException e) {
            this.handleError();
        }
    }

    private void handleError() {
        this.errorCount.incrementAndGet();
        LOG.warn("Couldn't deliver to " + this.myHomeReference + " error " + this.errorCount.get() + " of " + 5);
        if (this.errorCount.get() > 5) {
            LOG.warn(this.myHomeReference + " is obviously offline, removing");
            this.support.notifyBrokenConsumer(this);
            this.bridgeToHome = null;
        }
    }

    public String getChannelName() {
        return this.channelName;
    }

    public ServiceDescriptor getHomeReference() {
        return this.myHomeReference;
    }
}

