/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.integration.cdi;

import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.interceptor.InvocationContext;
import net.anotheria.moskito.core.dynamic.IOnDemandStatsFactory;
import net.anotheria.moskito.core.dynamic.OnDemandStatsProducer;
import net.anotheria.moskito.core.producers.IStats;
import net.anotheria.moskito.core.producers.IStatsProducer;
import net.anotheria.moskito.core.registry.ProducerRegistryFactory;
import net.anotheria.moskito.integration.cdi.ProducerDefinition;
import net.anotheria.moskito.integration.cdi.ProducerRuntimeDefinition;

public abstract class BaseInterceptor<S extends IStats>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private ConcurrentMap<String, OnDemandStatsProducer<S>> producers = new ConcurrentHashMap<String, OnDemandStatsProducer<S>>();

    protected OnDemandStatsProducer<S> getProducer(ProducerRuntimeDefinition prd) {
        String producerId = prd.getProducerId();
        OnDemandStatsProducer onDemandProducer = (OnDemandStatsProducer)this.producers.get(producerId);
        if (onDemandProducer == null) {
            onDemandProducer = new OnDemandStatsProducer(prd.getProducerId(), prd.getCategory(), prd.getSubsystem(), this.getFactory());
            OnDemandStatsProducer p = this.producers.putIfAbsent(producerId, onDemandProducer);
            if (p == null) {
                ProducerRegistryFactory.getProducerRegistryInstance().registerProducer((IStatsProducer)onDemandProducer);
            } else {
                onDemandProducer = p;
            }
        }
        return onDemandProducer;
    }

    protected abstract IOnDemandStatsFactory<S> getFactory();

    protected String extractCaseName(InvocationContext ctx) {
        return ctx.getMethod().getName();
    }

    protected ProducerRuntimeDefinition extractProducerDefinition(InvocationContext ctx) {
        return this.getProducerDefinitionFromClassOrAnnotation(ctx);
    }

    private ProducerRuntimeDefinition getProducerDefinitionFromClassOrAnnotation(InvocationContext ctx) {
        Class<?> c = ctx.getMethod().getDeclaringClass();
        ProducerDefinition ann = c.getAnnotation(ProducerDefinition.class);
        ProducerRuntimeDefinition ret = new ProducerRuntimeDefinition();
        if (ann == null) {
            ret.setProducerId(c.getSimpleName());
            ret.setCategory(this.getCategory());
            ret.setSubsystem(this.getSubsystem());
        } else {
            ret.setProducerId(ann.producerId());
            ret.setCategory(ann.category());
            ret.setSubsystem(ann.subsystem());
        }
        return ret;
    }

    protected String getCategory() {
        return "cdi";
    }

    protected String getSubsystem() {
        return "default";
    }
}

