/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.integration.cdi;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.inject.Singleton;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import net.anotheria.moskito.core.counter.CounterStats;
import net.anotheria.moskito.core.counter.CounterStatsFactory;
import net.anotheria.moskito.core.dynamic.IOnDemandStatsFactory;
import net.anotheria.moskito.core.dynamic.OnDemandStatsProducer;
import net.anotheria.moskito.core.dynamic.OnDemandStatsProducerException;
import net.anotheria.moskito.integration.cdi.BaseInterceptor;
import net.anotheria.moskito.integration.cdi.Count;
import net.anotheria.moskito.integration.cdi.ProducerRuntimeDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Interceptor
@Singleton
@Count
public class CountInterceptor
extends BaseInterceptor<CounterStats>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger log = LoggerFactory.getLogger(CountInterceptor.class);

    @AroundInvoke
    public Object aroundInvoke(InvocationContext ctx) throws Throwable {
        ProducerRuntimeDefinition prd = this.extractProducerDefinition(ctx);
        OnDemandStatsProducer onDemandProducer = this.getProducer(prd);
        CounterStats defaultStats = (CounterStats)onDemandProducer.getDefaultStats();
        CounterStats methodStats = null;
        String caseName = this.extractCaseName(ctx);
        try {
            if (caseName != null) {
                methodStats = (CounterStats)onDemandProducer.getStats(caseName);
            }
        }
        catch (OnDemandStatsProducerException e) {
            this.log.info("Couldn't get stats for case : " + caseName + ", probably limit reached");
        }
        Object[] args = ctx.getParameters();
        Method method = ctx.getMethod();
        defaultStats.inc();
        if (methodStats != null) {
            methodStats.inc();
        }
        Object ret = null;
        try {
            ret = ctx.proceed();
            return ret;
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    @Override
    protected IOnDemandStatsFactory getFactory() {
        return CounterStatsFactory.DEFAULT_INSTANCE;
    }

    @Override
    protected String getCategory() {
        return "counter";
    }
}

