/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.accumulation;

import java.util.ArrayList;
import java.util.List;
import net.anotheria.moskito.core.accumulation.AccumulatedValue;
import net.anotheria.moskito.core.accumulation.AccumulatorDefinition;
import net.anotheria.moskito.core.helper.AbstractTieable;
import net.anotheria.moskito.core.helper.Tieable;
import net.anotheria.moskito.core.producers.IStats;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Accumulator
extends AbstractTieable<AccumulatorDefinition>
implements Tieable {
    private static Logger log = LoggerFactory.getLogger(Accumulator.class);
    private List<AccumulatedValue> values;
    private IStats stats;

    public Accumulator(AccumulatorDefinition aDefinition) {
        super(aDefinition);
        this.values = new ArrayList<AccumulatedValue>(aDefinition.getMaxAmountOfAccumulatedItems());
    }

    public void addValue(AccumulatedValue value) {
        this.values.add(value);
        if (this.values.size() > ((AccumulatorDefinition)this.getDefinition()).getMaxAmountOfAccumulatedItems()) {
            this.values = this.values.subList(((AccumulatorDefinition)this.getDefinition()).getMaxAmountOfAccumulatedItems() - ((AccumulatorDefinition)this.getDefinition()).getAccumulationAmount() + 1, this.values.size());
        }
    }

    public void addValue(String aValue) {
        this.addValue(new AccumulatedValue(aValue));
    }

    public List<AccumulatedValue> getValues() {
        return this.values;
    }

    @Override
    public void update() {
        if (!this.isActivated()) {
            return;
        }
        String currentValue = this.stats.getValueByNameAsString(((AccumulatorDefinition)this.getDefinition()).getValueName(), ((AccumulatorDefinition)this.getDefinition()).getIntervalName(), ((AccumulatorDefinition)this.getDefinition()).getTimeUnit());
        if (log != null && log.isDebugEnabled()) {
            log.debug("UPDATED " + this + " with " + currentValue);
        }
        this.addValue(currentValue);
    }

    @Override
    public boolean isActivated() {
        return this.stats != null;
    }

    @Override
    public void tieToStats(IStats aStatsObject) {
        this.stats = aStatsObject;
    }

    public String toString() {
        return this.getId() + " " + this.getName() + " " + " Def: " + this.getDefinition() + " active: " + this.isActivated() + ", Values: " + (this.values == null ? "none" : "" + this.values.size());
    }
}

