/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.command;

import java.util.HashMap;
import java.util.Map;
import net.anotheria.moskito.core.command.CommandController;
import net.anotheria.moskito.core.command.CommandProcessor;
import net.anotheria.moskito.core.usecase.recorder.UseCaseRecorderCommandProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum CommandControllerImpl implements CommandController
{
    INSTANCE;

    private Map<String, CommandProcessor> processors = new HashMap<String, CommandProcessor>();
    private static final Logger log;

    private CommandControllerImpl() {
        this.registerCommandProcessor("recordUseCase", new UseCaseRecorderCommandProcessor());
    }

    @Override
    public void registerCommandProcessor(String command, CommandProcessor processor) {
        if (log != null) {
            log.debug("registering processor: " + processor + " for command: " + command);
        } else {
            LoggerFactory.getLogger(CommandControllerImpl.class).debug("registering processor: " + processor + " for command: " + command);
        }
        CommandProcessor oldProcessor = this.processors.put(command, processor);
        if (oldProcessor != null) {
            log.info("Implicitely unregistered processor: " + processor + " for command: " + command);
        }
    }

    @Override
    public void unregisterCommandProcessor(String command, CommandProcessor processor) {
        log.debug("unregistering processor: " + processor + " for command: " + command);
        CommandProcessor oldProcessor = this.processors.remove(command);
        if (oldProcessor == null) {
            log.info("Remove for command: " + command + " had no effect (no command previously registered)");
        }
    }

    @Override
    public void startCommand(String command, Map<String, String[]> parameters) {
        log.debug("startCommand(" + command + ", " + parameters + ")");
        CommandProcessor processor = this.processors.get(command);
        if (processor == null) {
            return;
        }
        try {
            processor.startCommand(command, parameters);
        }
        catch (Exception e) {
            log.error("caught in startCommand(" + command + ", " + parameters + ")", (Throwable)e);
        }
    }

    @Override
    public void stopCommand(String command, Map<String, String[]> parameters) {
        log.debug("stopCommand(" + command + ", " + parameters + ")");
        CommandProcessor processor = this.processors.get(command);
        if (processor == null) {
            return;
        }
        try {
            processor.stopCommand(command, parameters);
        }
        catch (Exception e) {
            log.error("caught in stopCommand(" + command + ", " + parameters + ")", (Throwable)e);
        }
    }

    static {
        log = LoggerFactory.getLogger(CommandControllerImpl.class);
    }
}

