/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.config;

import java.util.logging.Logger;
import net.anotheria.moskito.core.config.MoskitoConfiguration;
import net.anotheria.moskito.core.config.thresholds.NotificationProviderConfig;
import net.anotheria.moskito.core.threshold.alerts.notificationprovider.LogFileNotificationProvider;
import org.configureme.ConfigurationManager;

public enum MoskitoConfigurationHolder {
    INSTANCE;

    private final Logger log = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    private volatile MoskitoConfiguration configuration = MoskitoConfigurationHolder.createDefaultConfiguration();

    private MoskitoConfigurationHolder() {
        try {
            ConfigurationManager.INSTANCE.configure((Object)this.configuration);
        }
        catch (IllegalArgumentException e) {
            this.log.info("MoSKito configuration not found, working with default configuration, visit https://confluence.opensource.anotheria.net/display/MSK/Configuration+Guide for more details.");
        }
    }

    private static MoskitoConfiguration createDefaultConfiguration() {
        MoskitoConfiguration config = new MoskitoConfiguration();
        config.getThresholdsAlertsConfig().getAlertHistoryConfig().setMaxNumberOfItems(200);
        config.getThresholdsAlertsConfig().getAlertHistoryConfig().setToleratedNumberOfItems(220);
        NotificationProviderConfig[] providers = new NotificationProviderConfig[]{new NotificationProviderConfig()};
        providers[0].setClassName(LogFileNotificationProvider.class.getName());
        providers[0].setParameter("MoskitoAlert");
        config.getThresholdsAlertsConfig().setDispatcherThreadPoolSize(1);
        config.getAccumulatorsConfig().setAccumulationAmount(200);
        return config;
    }

    public static MoskitoConfiguration getConfiguration() {
        return MoskitoConfigurationHolder.INSTANCE.configuration;
    }

    public void setConfiguration(MoskitoConfiguration configuration) {
        this.configuration = configuration;
    }

    public static void resetConfiguration() {
        MoskitoConfigurationHolder.INSTANCE.configuration = MoskitoConfigurationHolder.createDefaultConfiguration();
    }
}

