/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.dynamic;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import net.anotheria.moskito.core.dynamic.IOnDemandStatsFactory;
import net.anotheria.moskito.core.dynamic.OnDemandStatsProducerException;
import net.anotheria.moskito.core.inspection.CreationInfo;
import net.anotheria.moskito.core.inspection.Inspectable;
import net.anotheria.moskito.core.producers.IStats;
import net.anotheria.moskito.core.producers.IStatsProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnDemandStatsProducer<S extends IStats>
implements IStatsProducer<S>,
Inspectable {
    private static Logger log = LoggerFactory.getLogger(OnDemandStatsProducer.class);
    private IOnDemandStatsFactory<S> factory;
    private List<S> _cachedStatsList;
    private final ConcurrentHashMap<String, S> stats;
    private S linkToDefaultStats;
    private String category;
    private String producerId;
    private String subsystem;
    private CreationInfo creationInfo;

    public OnDemandStatsProducer(String aProducerId, String aCategory, String aSubsystem, IOnDemandStatsFactory<S> aStatsFactory) {
        this.category = aCategory;
        this.producerId = aProducerId;
        this.subsystem = aSubsystem;
        this.factory = aStatsFactory;
        if (this.factory == null) {
            throw new IllegalArgumentException("Null factory is not allowed.");
        }
        this.stats = new ConcurrentHashMap();
        this._cachedStatsList = new CopyOnWriteArrayList<S>();
        try {
            this.linkToDefaultStats = this.getStats("cumulated");
        }
        catch (OnDemandStatsProducerException ignored) {
            log.error("couldn't get link to default stats, probably the limitation is far too low.");
        }
        Exception e = new Exception();
        e.fillInStackTrace();
        this.creationInfo = new CreationInfo(e.getStackTrace());
    }

    public S getStats(String name) throws OnDemandStatsProducerException {
        IStats stat = (IStats)this.stats.get(name);
        if (stat == null) {
            if (this.limitForNewEntriesReached()) {
                throw new OnDemandStatsProducerException("Limit reached");
            }
            stat = this.factory.createStatsObject(name);
            IStats old = this.stats.putIfAbsent(name, stat);
            if (old == null) {
                this._cachedStatsList.add(stat);
            } else {
                stat = old;
            }
        }
        return (S)stat;
    }

    @Override
    public String getCategory() {
        return this.category == null ? "default" : this.category;
    }

    @Override
    public String getProducerId() {
        return this.producerId;
    }

    @Override
    public List<S> getStats() {
        return this._cachedStatsList;
    }

    @Override
    public String getSubsystem() {
        return this.subsystem == null ? "default" : this.subsystem;
    }

    public S getDefaultStats() {
        return this.linkToDefaultStats;
    }

    public String toString() {
        return "OnDemandProducer (" + this.getProducerNameExtension() + "): " + this.getProducerId() + ":" + this.getSubsystem() + ":" + this.getCategory();
    }

    protected boolean limitForNewEntriesReached() {
        return false;
    }

    protected String getProducerNameExtension() {
        return "unlimited";
    }

    protected List<S> getCachedStatsList() {
        return this._cachedStatsList;
    }

    @Override
    public CreationInfo getCreationInfo() {
        return this.creationInfo;
    }
}

