/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.predefined;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.anotheria.moskito.core.predefined.IMemoryPoolStats;
import net.anotheria.moskito.core.producers.AbstractStats;
import net.anotheria.moskito.core.stats.TimeUnit;

public abstract class AbstractMemoryPoolStats
extends AbstractStats
implements IMemoryPoolStats {
    private static final List<String> VALUE_NAMES = Collections.unmodifiableList(Arrays.asList("INIT", "MIN_USED", "USED", "MAX_USED", "MIN_COMMITED", "COMMITED", "MAX_COMMITED", "MAX"));

    protected AbstractMemoryPoolStats(String name) {
        super(name);
    }

    @Override
    public List<String> getAvailableValueNames() {
        return VALUE_NAMES;
    }

    @Override
    public String getValueByNameAsString(String valueName, String intervalName, TimeUnit timeUnit) {
        if (valueName == null || valueName.equals("")) {
            throw new AssertionError((Object)"Value name can not be empty");
        }
        if ((valueName = valueName.toLowerCase()).equals("init")) {
            return "" + this.getInit(intervalName);
        }
        if (valueName.equals("min_used")) {
            return "" + this.getMinUsed(intervalName);
        }
        if (valueName.equals("used")) {
            return "" + this.getUsed(intervalName);
        }
        if (valueName.equals("used mb")) {
            return "" + this.getUsed(intervalName) / 0x100000L;
        }
        if (valueName.equals("max_used")) {
            return "" + this.getMaxUsed(intervalName);
        }
        if (valueName.equals("min_commited")) {
            return "" + this.getMinCommited(intervalName);
        }
        if (valueName.equals("commited")) {
            return "" + this.getCommited(intervalName);
        }
        if (valueName.equals("max_commited")) {
            return "" + this.getMaxCommited(intervalName);
        }
        if (valueName.equals("max")) {
            return "" + this.getMax(intervalName);
        }
        if (valueName.equals("free")) {
            return "" + this.getFree(intervalName);
        }
        if (valueName.equals("free mb")) {
            return "" + this.getFree(intervalName) / 0x100000L;
        }
        return super.getValueByNameAsString(valueName, intervalName, timeUnit);
    }
}

