/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.predefined;

import java.util.ArrayList;
import java.util.Collection;
import java.util.TimerTask;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import net.anotheria.moskito.core.predefined.Constants;
import net.anotheria.moskito.core.producers.GenericStats;
import net.anotheria.moskito.core.stats.Interval;
import net.anotheria.moskito.core.stats.StatValue;
import net.anotheria.moskito.core.stats.StatValueTypes;
import net.anotheria.moskito.core.stats.TypeAwareStatValue;
import net.anotheria.moskito.core.stats.impl.StatValueFactory;
import net.anotheria.moskito.core.util.BuiltinUpdater;
import net.anotheria.moskito.core.util.MBeanProducerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MBeanStatsList
extends ArrayList<GenericStats> {
    private static final long serialVersionUID = 1776269894160250078L;
    private static final Logger LOGGER = LoggerFactory.getLogger(MBeanStatsList.class);
    private final MBeanServer server;
    private final ObjectName mbean;

    public MBeanStatsList(MBeanServer server, ObjectName mbean, boolean enableAutoUpdate, long delay) {
        this.server = server;
        this.mbean = mbean;
        this.initStatsList();
        if (enableAutoUpdate) {
            this.initUpdateTimer(delay);
        }
    }

    @Override
    public boolean add(GenericStats e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(int index, GenericStats element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends GenericStats> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int index, Collection<? extends GenericStats> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public GenericStats remove(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public GenericStats set(int index, GenericStats element) {
        throw new UnsupportedOperationException();
    }

    public void update() {
        for (GenericStats gs : this) {
            for (StatValue statValue : gs.getAllValues()) {
                this.updateValue((XStatValue)statValue);
            }
        }
    }

    private XStatValue buildValue(MBeanAttributeInfo attribute) {
        StatValueTypes sType = this.getStatValueType(attribute);
        if (sType == null) {
            return null;
        }
        String attribName = attribute.getName();
        return new XStatValue(attribute, StatValueFactory.createStatValue(sType, attribName, Constants.getDefaultIntervals()));
    }

    private Collection<MBeanAttributeInfo> getAttributes() {
        ArrayList<MBeanAttributeInfo> attributes = new ArrayList<MBeanAttributeInfo>();
        try {
            MBeanAttributeInfo[] all;
            for (MBeanAttributeInfo attribute : all = this.server.getMBeanInfo(this.mbean).getAttributes()) {
                attributes.add(attribute);
            }
        }
        catch (IntrospectionException e) {
            LOGGER.info("unable to determine attributes of MBean: " + this.mbean, (Throwable)e);
        }
        catch (InstanceNotFoundException e) {
            LOGGER.info("unable to determine attributes of MBean: " + this.mbean, (Throwable)e);
        }
        catch (ReflectionException e) {
            LOGGER.info("unable to determine attributes of MBean: " + this.mbean, (Throwable)e);
        }
        return attributes;
    }

    private StatValueTypes getStatValueType(MBeanAttributeInfo attribute) {
        String type = attribute.getType();
        if ("long".equals(type)) {
            return StatValueTypes.LONG;
        }
        if ("int".equals(type)) {
            return StatValueTypes.INT;
        }
        if ("double".equals(type)) {
            return StatValueTypes.DOUBLE;
        }
        if ("String".equals(type) || "boolean".equals(type)) {
            return StatValueTypes.STRING;
        }
        return null;
    }

    private void initStatsList() {
        Collection<MBeanAttributeInfo> attributes = this.getAttributes();
        if (attributes.isEmpty()) {
            return;
        }
        GenericStats gs = new GenericStats(MBeanProducerFactory.normalize(this.mbean.getCanonicalKeyPropertyListString()));
        for (MBeanAttributeInfo attribute : attributes) {
            XStatValue sValue = this.buildValue(attribute);
            if (sValue == null) continue;
            gs.putValue(sValue);
        }
        if (gs.hasValues()) {
            super.add(gs);
        }
    }

    private void initUpdateTimer(long delay) {
        BuiltinUpdater.addTask(new TimerTask(){

            @Override
            public void run() {
                MBeanStatsList.this.update();
            }
        }, delay);
    }

    private void updateValue(XStatValue xsValue) {
        if (xsValue.isIgnoreMe()) {
            return;
        }
        MBeanAttributeInfo attribute = xsValue.getAttribute();
        if (!attribute.isReadable()) {
            return;
        }
        String attribName = attribute.getName();
        try {
            Object value = this.server.getAttribute(this.mbean, attribName);
            if (value instanceof Long) {
                xsValue.setValueAsLong((Long)value);
            } else if (value instanceof Integer) {
                xsValue.setValueAsInt((Integer)value);
            } else if (value instanceof Double) {
                xsValue.setValueAsDouble((Double)value);
            } else {
                xsValue.setValueAsString(value == null ? "null" : value.toString());
            }
        }
        catch (Exception e) {
            xsValue.setIgnoreMe(true);
            LOGGER.info("unable to extract value of attribute " + attribName + ". it will be ignored in future. message was: " + e.getLocalizedMessage());
        }
    }

    private static final class XStatValue
    implements TypeAwareStatValue {
        private final MBeanAttributeInfo attribute;
        private final TypeAwareStatValue delegate;
        private boolean ignoreMe;

        private XStatValue(MBeanAttributeInfo attribute, TypeAwareStatValue delegate) {
            this.attribute = attribute;
            this.delegate = delegate;
        }

        @Override
        public void addInterval(Interval aInterval) {
            this.delegate.addInterval(aInterval);
        }

        @Override
        public void decrease() {
            this.delegate.decrease();
        }

        @Override
        public void decreaseByDouble(double aValue) {
            this.delegate.decreaseByDouble(aValue);
        }

        @Override
        public void decreaseByInt(int aValue) {
            this.delegate.decreaseByInt(aValue);
        }

        @Override
        public void decreaseByLong(long aValue) {
            this.delegate.decreaseByLong(aValue);
        }

        public MBeanAttributeInfo getAttribute() {
            return this.attribute;
        }

        @Override
        public String getName() {
            return this.delegate.getName();
        }

        @Override
        public StatValueTypes getType() {
            return this.delegate.getType();
        }

        @Override
        public double getValueAsDouble() {
            return this.delegate.getValueAsDouble();
        }

        @Override
        public double getValueAsDouble(String aIntervalName) {
            return this.delegate.getValueAsDouble(aIntervalName);
        }

        @Override
        public int getValueAsInt() {
            return this.delegate.getValueAsInt();
        }

        @Override
        public int getValueAsInt(String aIntervalName) {
            return this.delegate.getValueAsInt(aIntervalName);
        }

        @Override
        public long getValueAsLong() {
            return this.delegate.getValueAsLong();
        }

        @Override
        public long getValueAsLong(String aIntervalName) {
            return this.delegate.getValueAsLong(aIntervalName);
        }

        @Override
        public String getValueAsString() {
            return this.delegate.getValueAsString();
        }

        @Override
        public String getValueAsString(String anIntervalName) {
            return this.delegate.getValueAsString(anIntervalName);
        }

        @Override
        public void increase() {
            this.delegate.increase();
        }

        @Override
        public void increaseByDouble(double aValue) {
            this.delegate.increaseByDouble(aValue);
        }

        @Override
        public void increaseByInt(int aValue) {
            this.delegate.increaseByInt(aValue);
        }

        @Override
        public void increaseByLong(long aValue) {
            this.delegate.increaseByLong(aValue);
        }

        public boolean isIgnoreMe() {
            return this.ignoreMe;
        }

        @Override
        public void reset() {
            this.delegate.reset();
        }

        @Override
        public void setDefaultValueAsDouble(double aValue) {
            this.delegate.setDefaultValueAsDouble(aValue);
        }

        @Override
        public void setDefaultValueAsInt(int aValue) {
            this.delegate.setDefaultValueAsInt(aValue);
        }

        @Override
        public void setDefaultValueAsLong(long aValue) {
            this.delegate.setDefaultValueAsLong(aValue);
        }

        public void setIgnoreMe(boolean ignoreMe) {
            this.ignoreMe = ignoreMe;
        }

        @Override
        public void setValueAsDouble(double aValue) {
            this.delegate.setValueAsDouble(aValue);
        }

        @Override
        public void setValueAsInt(int aValue) {
            this.delegate.setValueAsInt(aValue);
        }

        @Override
        public void setValueAsLong(long aValue) {
            this.delegate.setValueAsLong(aValue);
        }

        @Override
        public void setValueAsString(String aValue) {
            this.delegate.setValueAsString(aValue);
        }

        @Override
        public void setValueIfGreaterThanCurrentAsDouble(double aValue) {
            this.delegate.setValueIfGreaterThanCurrentAsDouble(aValue);
        }

        @Override
        public void setValueIfGreaterThanCurrentAsInt(int aValue) {
            this.delegate.setValueIfGreaterThanCurrentAsInt(aValue);
        }

        @Override
        public void setValueIfGreaterThanCurrentAsLong(long aValue) {
            this.delegate.setValueIfGreaterThanCurrentAsLong(aValue);
        }

        @Override
        public void setValueIfLesserThanCurrentAsDouble(double aValue) {
            this.delegate.setValueIfLesserThanCurrentAsDouble(aValue);
        }

        @Override
        public void setValueIfLesserThanCurrentAsInt(int aValue) {
            this.delegate.setValueIfLesserThanCurrentAsInt(aValue);
        }

        @Override
        public void setValueIfLesserThanCurrentAsLong(long aValue) {
            this.delegate.setValueIfLesserThanCurrentAsLong(aValue);
        }
    }
}

