/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.predefined;

import net.anotheria.moskito.core.predefined.Constants;
import net.anotheria.moskito.core.producers.AbstractStats;
import net.anotheria.moskito.core.stats.Interval;
import net.anotheria.moskito.core.stats.StatValue;
import net.anotheria.moskito.core.stats.TimeUnit;
import net.anotheria.moskito.core.stats.impl.StatValueFactory;

public class MemoryStats
extends AbstractStats {
    private StatValue current;
    private StatValue min;
    private StatValue max;

    public MemoryStats() {
        this("unnamed", Constants.getDefaultIntervals());
    }

    public MemoryStats(String aName) {
        this(aName, Constants.getDefaultIntervals());
    }

    public MemoryStats(String aName, Interval[] selectedIntervals) {
        super(aName);
        this.current = StatValueFactory.createStatValue(0L, "current", selectedIntervals);
        this.min = StatValueFactory.createStatValue(0L, "min", selectedIntervals);
        this.max = StatValueFactory.createStatValue(0L, "max", selectedIntervals);
    }

    @Override
    public String toStatsString(String intervalName, TimeUnit timeUnit) {
        StringBuilder b = new StringBuilder();
        b.append(this.getName()).append(' ');
        b.append(" CUR: ").append(this.current.getValueAsLong(intervalName));
        b.append(" MIN: ").append(this.min.getValueAsLong(intervalName));
        b.append(" MAX: ").append(this.max.getValueAsLong(intervalName));
        return b.toString();
    }

    public void updateMemoryValue(long value) {
        this.current.setValueAsLong(value);
        this.min.setValueIfLesserThanCurrentAsLong(value);
        this.max.setValueIfGreaterThanCurrentAsLong(value);
    }

    public long getCurrent(String intervalName) {
        return this.current.getValueAsLong(intervalName);
    }

    public long getMin(String intervalName) {
        return this.min.getValueAsLong(intervalName);
    }

    public long getMax(String intervalName) {
        return this.max.getValueAsLong(intervalName);
    }
}

