/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.predefined;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.anotheria.moskito.core.calltrace.CurrentlyTracedCall;
import net.anotheria.moskito.core.calltrace.RunningTraceContainer;
import net.anotheria.moskito.core.calltrace.TraceStep;
import net.anotheria.moskito.core.calltrace.TracedCall;
import net.anotheria.moskito.core.dynamic.IOnDemandCallHandler;
import net.anotheria.moskito.core.predefined.ServiceStats;
import net.anotheria.moskito.core.producers.IStats;
import net.anotheria.moskito.core.producers.IStatsProducer;

public class ServiceStatsCallHandler
implements IOnDemandCallHandler {
    @Override
    public Object invoke(Object target, Object[] args, Method method, Class<?> targetClass, Class<?>[] declaredExceptions, IStats aDefaultStats, IStats aMethodStats, IStatsProducer producer) throws Throwable {
        CurrentlyTracedCall currentTrace;
        ServiceStats defaultStats = (ServiceStats)aDefaultStats;
        ServiceStats methodStats = (ServiceStats)aMethodStats;
        defaultStats.addRequest();
        methodStats.addRequest();
        TracedCall aRunningTrace = RunningTraceContainer.getCurrentlyTracedCall();
        TraceStep currentStep = null;
        CurrentlyTracedCall currentlyTracedCall = currentTrace = aRunningTrace.callTraced() ? (CurrentlyTracedCall)aRunningTrace : null;
        if (currentTrace != null) {
            StringBuilder call = new StringBuilder(producer.getProducerId()).append('.').append(method.getName()).append("(");
            if (args != null && args.length > 0) {
                for (int i = 0; i < args.length; ++i) {
                    call.append(args[i]);
                    if (i >= args.length - 1) continue;
                    call.append(", ");
                }
            }
            call.append(")");
            currentStep = currentTrace.startStep(call.toString(), producer);
        }
        long startTime = System.nanoTime();
        Object ret = null;
        try {
            Object object = ret = method.invoke(target, args);
            return object;
        }
        catch (InvocationTargetException e) {
            defaultStats.notifyError();
            methodStats.notifyError();
            if (currentStep != null) {
                currentStep.setAborted();
            }
            throw e.getCause();
        }
        catch (Throwable t) {
            defaultStats.notifyError();
            methodStats.notifyError();
            if (currentStep != null) {
                currentStep.setAborted();
            }
            throw t;
        }
        finally {
            long exTime = System.nanoTime() - startTime;
            defaultStats.addExecutionTime(exTime);
            methodStats.addExecutionTime(exTime);
            defaultStats.notifyRequestFinished();
            methodStats.notifyRequestFinished();
            if (currentStep != null) {
                currentStep.setDuration(exTime);
                try {
                    currentStep.appendToCall(" = " + ret);
                }
                catch (Throwable t) {
                    currentStep.appendToCall(" = ERR: " + t.getMessage() + " (" + t.getClass() + ")");
                }
            }
            if (currentTrace != null) {
                currentTrace.endStep();
            }
        }
    }
}

