/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.predefined;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.anotheria.moskito.core.predefined.Constants;
import net.anotheria.moskito.core.producers.AbstractStats;
import net.anotheria.moskito.core.stats.Interval;
import net.anotheria.moskito.core.stats.StatValue;
import net.anotheria.moskito.core.stats.TimeUnit;
import net.anotheria.moskito.core.stats.impl.StatValueFactory;

public class ThreadCountStats
extends AbstractStats {
    private static final List<String> VALUE_NAMES = Collections.unmodifiableList(Arrays.asList("Started", "Min", "Max", "Daemon", "Cur"));
    private StatValue started;
    private StatValue current;
    private StatValue daemon;
    private StatValue minCurrent;
    private StatValue maxCurrent;

    public ThreadCountStats() {
        this(Constants.getDefaultIntervals());
    }

    public ThreadCountStats(Interval[] intervals) {
        super("ThreadCount");
        Long pattern = 0L;
        this.current = StatValueFactory.createStatValue(pattern, "current", intervals);
        this.minCurrent = StatValueFactory.createStatValue(pattern, "minCurrent", intervals);
        this.minCurrent.setDefaultValueAsInt(Integer.MAX_VALUE);
        this.minCurrent.reset();
        this.maxCurrent = StatValueFactory.createStatValue(pattern, "maxCurrent", intervals);
        this.maxCurrent.setDefaultValueAsInt(Integer.MIN_VALUE);
        this.maxCurrent.reset();
        this.started = StatValueFactory.createStatValue(pattern, "started", intervals);
        this.daemon = StatValueFactory.createStatValue(pattern, "daemon", intervals);
    }

    public void update(long aStarted, long aDaemon, long aCurrent) {
        this.current.setValueAsLong(aCurrent);
        this.started.setValueAsLong(aStarted);
        this.daemon.setValueAsLong(aDaemon);
        this.minCurrent.setValueIfLesserThanCurrentAsLong(aCurrent);
        this.maxCurrent.setValueIfGreaterThanCurrentAsLong(aCurrent);
    }

    @Override
    public String toStatsString(String intervalName, TimeUnit unit) {
        StringBuilder ret = new StringBuilder("Sessions ");
        ret.append(" Current: ").append(this.current.getValueAsInt(intervalName));
        ret.append(" Min: ").append(this.minCurrent.getValueAsInt(intervalName));
        ret.append(" Max: ").append(this.maxCurrent.getValueAsInt(intervalName));
        ret.append(" Started: ").append(this.started.getValueAsInt(intervalName));
        ret.append(" Daemon: ").append(this.daemon.getValueAsInt(intervalName));
        return ret.toString();
    }

    public long getStarted(String interval) {
        return this.started.getValueAsLong(interval);
    }

    public long getDaemon(String interval) {
        return this.daemon.getValueAsLong(interval);
    }

    public long getCurrent(String interval) {
        return this.current.getValueAsLong(interval);
    }

    public long getMinCurrent(String interval) {
        return this.minCurrent.getValueAsLong(interval);
    }

    public long getMaxCurrent(String interval) {
        return this.maxCurrent.getValueAsLong(interval);
    }

    @Override
    public String getValueByNameAsString(String valueName, String intervalName, TimeUnit timeUnit) {
        if (valueName == null) {
            return null;
        }
        if ((valueName = valueName.toLowerCase()).equals("cur") || valueName.equals("current")) {
            return "" + this.getCurrent(intervalName);
        }
        if (valueName.equals("min") || valueName.equals("mincurrent") || valueName.equals("min cur")) {
            return "" + this.getMinCurrent(intervalName);
        }
        if (valueName.equals("max") || valueName.equals("maxcurrent") || valueName.equals("max cur")) {
            return "" + this.getMaxCurrent(intervalName);
        }
        if (valueName.equals("started")) {
            return "" + this.getStarted(intervalName);
        }
        if (valueName.equals("daemon")) {
            return "" + this.getDaemon(intervalName);
        }
        return super.getValueByNameAsString(valueName, intervalName, timeUnit);
    }

    @Override
    public List<String> getAvailableValueNames() {
        return VALUE_NAMES;
    }
}

