/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.registry;

import java.lang.management.ManagementFactory;
import java.util.List;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import net.anotheria.moskito.core.helper.RuntimeConstants;
import net.anotheria.moskito.core.producers.IStats;
import net.anotheria.moskito.core.producers.IStatsProducer;
import net.anotheria.moskito.core.registry.IProducerRegistryListener;
import net.anotheria.moskito.core.util.BuiltInProducer;
import net.anotheria.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMXBridgeListener
implements IProducerRegistryListener {
    private static Logger log = LoggerFactory.getLogger(JMXBridgeListener.class);
    private static final char[] CHARS_TO_REMOVE_FROM_NAME = new char[]{' ', '\t', '\r', '\n'};

    public void notifyProducerRegistered(IStatsProducer producer) {
        if (producer instanceof BuiltInProducer) {
            return;
        }
        List stats = producer.getStats();
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        if (stats == null) {
            return;
        }
        for (IStats s : stats) {
            try {
                ObjectName name = this.createName(producer.getProducerId(), s.getName());
                mbs.registerMBean(s, name);
            }
            catch (InstanceAlreadyExistsException e) {
                log.warn("can't register " + s.getName() + " in " + producer.getProducerId() + ", ignored InstanceAlreadyExistsException.");
            }
            catch (Exception e) {
                log.warn("can't register " + s.getName() + " in " + producer.getProducerId() + ", ignored.", (Throwable)e);
            }
        }
    }

    public void notifyProducerUnregistered(IStatsProducer producer) {
        List stats = producer.getStats();
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        if (stats == null) {
            return;
        }
        for (IStats s : stats) {
            try {
                ObjectName name = this.createName(producer.getProducerId(), s.getName());
                mbs.unregisterMBean(name);
            }
            catch (InstanceNotFoundException e) {
                log.debug("can't unregister " + s.getName() + " in " + producer.getProducerId() + ", ignored InstanceNotFoundException.");
            }
            catch (Exception e) {
                log.warn("can't unregister " + s.getName() + " in " + producer.getProducerId() + ", ignored.", (Throwable)e);
            }
        }
    }

    private ObjectName createName(String producerId, String statName) throws MalformedObjectNameException {
        String appName = this.encodeAppName(RuntimeConstants.getApplicationName());
        String objectName = "MoSKito." + (appName.length() > 0 ? appName + "." : "") + "producers:type=" + producerId + "." + statName;
        ObjectName objName = new ObjectName(objectName);
        return objName;
    }

    private String encodeAppName(String appName) {
        return StringUtils.removeChars((String)appName, (char[])CHARS_TO_REMOVE_FROM_NAME);
    }
}

