/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.registry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import net.anotheria.moskito.core.producers.IStatsProducer;
import net.anotheria.moskito.core.registry.IProducerRegistry;
import net.anotheria.moskito.core.registry.IProducerRegistryListener;
import net.anotheria.moskito.core.registry.JMXBridgeListener;
import net.anotheria.moskito.core.registry.ProducerReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProducerRegistryImpl
implements IProducerRegistry {
    private static Logger log = LoggerFactory.getLogger(ProducerRegistryImpl.class);
    private List<IProducerRegistryListener> listeners = new CopyOnWriteArrayList<IProducerRegistryListener>();
    private Map<String, ProducerReference> registry = new ConcurrentHashMap<String, ProducerReference>();

    ProducerRegistryImpl() {
        this.reset();
    }

    @Override
    public void addListener(IProducerRegistryListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(IProducerRegistryListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public Collection<IStatsProducer> getProducers() {
        ArrayList<IStatsProducer> ret = new ArrayList<IStatsProducer>();
        for (ProducerReference r : this.getProducerReferences()) {
            if (r.get() == null) continue;
            ret.add(r.get());
        }
        return ret;
    }

    @Override
    public Collection<ProducerReference> getProducerReferences() {
        return this.registry.values();
    }

    @Override
    public IStatsProducer getProducer(String producerId) {
        if (producerId == null) {
            throw new IllegalArgumentException("Null is not a valid producerId");
        }
        ProducerReference ref = this.registry.get(producerId);
        return ref == null ? null : ref.get();
    }

    @Override
    public void registerProducer(IStatsProducer producer) {
        IStatsProducer previous;
        String producerToString = null;
        try {
            producerToString = producer.toString();
        }
        catch (Exception e) {
            producerToString = "Illegal to string method: " + e.getMessage() + ", " + e.getClass();
        }
        log.info("Registry register producer: " + producer.getProducerId() + " / " + producerToString);
        ProducerReference previousRef = this.registry.put(producer.getProducerId(), new ProducerReference(producer));
        IStatsProducer iStatsProducer = previous = previousRef == null ? null : previousRef.get();
        if (previous != null) {
            log.info("Under this name a producer was already registered: " + previous);
        }
        for (IProducerRegistryListener listener : this.listeners) {
            if (previous != null) {
                listener.notifyProducerUnregistered(previous);
            }
            listener.notifyProducerRegistered(producer);
        }
    }

    @Override
    public void unregisterProducer(IStatsProducer producer) {
        this.registry.remove(producer.getProducerId());
        for (IProducerRegistryListener listener : this.listeners) {
            listener.notifyProducerUnregistered(producer);
        }
    }

    void reset() {
        this.cleanup();
        this.listeners.clear();
        this.registry.clear();
        String junittest = System.getProperty("JUNITTEST");
        if (junittest != null && junittest.equalsIgnoreCase("true")) {
            return;
        }
        this.addListener(new JMXBridgeListener());
    }

    @Override
    public void cleanup() {
        ArrayList<ProducerReference> producerReferences = new ArrayList<ProducerReference>();
        producerReferences.addAll(this.registry.values());
        for (ProducerReference p : producerReferences) {
            try {
                if (p.get() == null) continue;
                this.unregisterProducer(p.get());
            }
            catch (Exception e) {
                log.warn("can't unregister producer " + p, (Throwable)e);
            }
        }
    }
}

