/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.snapshot;

import java.util.List;
import net.anotheria.moskito.core.producers.IStats;
import net.anotheria.moskito.core.producers.IStatsProducer;
import net.anotheria.moskito.core.snapshot.ProducerSnapshot;
import net.anotheria.moskito.core.snapshot.StatSnapshot;
import net.anotheria.moskito.core.stats.TimeUnit;

public class SnapshotCreator {
    public static ProducerSnapshot createSnapshot(IStatsProducer producer, String intervalName) {
        ProducerSnapshot ret = new ProducerSnapshot();
        ret.setCategory(producer.getCategory());
        ret.setSubsystem(producer.getSubsystem());
        ret.setProducerId(producer.getProducerId());
        ret.setIntervalName(intervalName);
        List stats = producer.getStats();
        if (stats != null && stats.size() > 0) {
            ret.setStatClassName(((IStats)stats.get(0)).getClass().getName());
        }
        if (stats == null || stats.size() == 0) {
            return ret;
        }
        List<String> cachedValueNames = ((IStats)stats.get(0)).getAvailableValueNames();
        for (IStats stat : stats) {
            ret.addSnapshot(SnapshotCreator.createStatSnapshot(stat, intervalName, cachedValueNames));
        }
        return ret;
    }

    private static StatSnapshot createStatSnapshot(IStats stat, String intervalName, List<String> valueNames) {
        StatSnapshot snapshot = new StatSnapshot(stat.getName());
        for (String valueName : valueNames) {
            snapshot.setValue(valueName, stat.getValueByNameAsString(valueName, intervalName, TimeUnit.NANOSECONDS));
        }
        return snapshot;
    }
}

