/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.stats.impl;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.anotheria.moskito.core.stats.IIntervalListener;
import net.anotheria.moskito.core.stats.Interval;
import net.anotheria.moskito.core.timing.IUpdateable;

class IntervalImpl
implements IUpdateable,
Interval {
    private String name;
    private int id;
    private int length;
    private List<IIntervalListener> primaryIntervalListeners;
    private List<IIntervalListener> secondaryIntervalListeners;

    public IntervalImpl(int anId, String aName, int aLength) {
        this.id = anId;
        this.name = aName;
        this.length = aLength;
        this.primaryIntervalListeners = new CopyOnWriteArrayList<IIntervalListener>();
        this.secondaryIntervalListeners = new CopyOnWriteArrayList<IIntervalListener>();
    }

    @Override
    public void addPrimaryIntervalListener(IIntervalListener aListener) {
        this.primaryIntervalListeners.add(aListener);
    }

    @Override
    public void removePrimaryIntervalListener(IIntervalListener aListener) {
        this.primaryIntervalListeners.remove(aListener);
    }

    @Override
    public void addSecondaryIntervalListener(IIntervalListener aListener) {
        this.secondaryIntervalListeners.add(aListener);
    }

    @Override
    public void removeSecondaryIntervalListener(IIntervalListener aListener) {
        this.secondaryIntervalListeners.remove(aListener);
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public void update() {
        this.notifyListeners(this.primaryIntervalListeners);
        this.notifyListeners(this.secondaryIntervalListeners);
    }

    private void notifyListeners(List<IIntervalListener> aListeners) {
        for (IIntervalListener listener : aListeners) {
            listener.intervalUpdated(this);
        }
    }

    public String toString() {
        return "[" + this.id + "] " + this.name + " length: " + this.length + ", " + this.primaryIntervalListeners.size() + " / " + this.secondaryIntervalListeners.size();
    }
}

