/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.threshold.alerts;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.anotheria.moskito.core.config.MoskitoConfigurationHolder;
import net.anotheria.moskito.core.threshold.alerts.ThresholdAlert;

public enum AlertHistory {
    INSTANCE;

    private List<ThresholdAlert> alerts = new CopyOnWriteArrayList<ThresholdAlert>();
    private ReadWriteLock lock = new ReentrantReadWriteLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAlert(ThresholdAlert alert) {
        this.lock.writeLock().lock();
        try {
            this.alerts.add(alert);
            if (this.alerts.size() > MoskitoConfigurationHolder.getConfiguration().getThresholdsAlertsConfig().getAlertHistoryConfig().getToleratedNumberOfItems()) {
                this.alerts = this.alerts.subList(this.alerts.size() - MoskitoConfigurationHolder.getConfiguration().getThresholdsAlertsConfig().getAlertHistoryConfig().getMaxNumberOfItems(), this.alerts.size() - 1);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public List<ThresholdAlert> getAlerts() {
        ArrayList<ThresholdAlert> ret = new ArrayList<ThresholdAlert>();
        ret.addAll(this.alerts);
        Collections.reverse(ret);
        return ret;
    }
}

