/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.threshold.alerts.notificationprovider;

import java.util.ArrayList;
import java.util.List;
import net.anotheria.communication.data.AbstractMessage;
import net.anotheria.communication.data.SimpleMailMessage;
import net.anotheria.communication.service.MessagingService;
import net.anotheria.moskito.core.threshold.alerts.NotificationProvider;
import net.anotheria.moskito.core.threshold.alerts.ThresholdAlert;
import net.anotheria.util.NumberUtils;
import net.anotheria.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailNotificationProvider
implements NotificationProvider {
    private List<String> recipients = new ArrayList<String>();
    private MessagingService messagingService;
    private static Logger log = LoggerFactory.getLogger(MailNotificationProvider.class);

    @Override
    public void configure(String parameter) {
        try {
            String[] tokens;
            this.messagingService = MessagingService.getInstance();
            for (String t : tokens = StringUtils.tokenize((String)parameter, (char)',')) {
                if (t.length() <= 0) continue;
                this.recipients.add(t.trim());
            }
        }
        catch (Throwable t) {
            log.warn("couldn't parse recipients  " + parameter, t);
        }
    }

    @Override
    public void onNewAlert(ThresholdAlert alert) {
        String subject = "Threshold alert: " + alert;
        String mailtext = "Threshold alert:\n";
        mailtext = mailtext + "Timestamp: " + alert.getTimestamp() + "\n";
        mailtext = mailtext + "ISO Timestamp: " + NumberUtils.makeISO8601TimestampString((long)alert.getTimestamp()) + "\n";
        mailtext = mailtext + "Threshold: " + alert.getThreshold() + "\n";
        mailtext = mailtext + "OldStatus: " + (Object)((Object)alert.getOldStatus()) + "\n";
        mailtext = mailtext + "NewStatus: " + (Object)((Object)alert.getNewStatus()) + "\n";
        mailtext = mailtext + "OldValue: " + alert.getOldValue() + "\n";
        mailtext = mailtext + "NewValue: " + alert.getNewValue() + "\n";
        SimpleMailMessage message = new SimpleMailMessage();
        message.setSender("moskito@anotheria.net");
        message.setSenderName("MoSKito Threshold Alert");
        message.setSubject(subject);
        message.setMessage(mailtext);
        for (String r : this.recipients) {
            message.setRecipient(r);
            try {
                boolean sent = this.messagingService.sendMessage((AbstractMessage)message);
                if (sent) continue;
                log.error("Can't send message to " + r);
            }
            catch (Exception e) {
                log.error("onNewAlert(" + alert + "), to:  " + r + ")", (Throwable)e);
            }
        }
    }
}

