/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.threshold.guard;

import net.anotheria.moskito.core.threshold.Threshold;
import net.anotheria.moskito.core.threshold.ThresholdConditionGuard;
import net.anotheria.moskito.core.threshold.ThresholdStatus;
import net.anotheria.moskito.core.threshold.guard.GuardedDirection;

public abstract class BarrierPassGuard
implements ThresholdConditionGuard {
    private ThresholdStatus targetStatus;
    private GuardedDirection direction;

    public BarrierPassGuard(ThresholdStatus aTargetStatus, GuardedDirection aDirection) {
        this.targetStatus = aTargetStatus;
        this.direction = aDirection;
    }

    @Override
    public ThresholdStatus getNewStatusOnUpdate(String previousValue, String newValue, ThresholdStatus currentStatus, Threshold threshold) {
        if (newValue == null || newValue.equals("NaN")) {
            return currentStatus;
        }
        ThresholdStatus ret = this.direction.brokeThrough(this.getValueAsNumber(newValue), this.getBarrierValueAsNumber()) ? this.targetStatus : ThresholdStatus.OFF;
        return ret;
    }

    public String toString() {
        return (Object)((Object)this.targetStatus) + " if " + (Object)((Object)this.direction) + " " + this.getValueAsString();
    }

    public abstract String getValueAsString();

    protected abstract Number getValueAsNumber(String var1);

    protected abstract Number getBarrierValueAsNumber();

    public ThresholdStatus getTargetStatus() {
        return this.targetStatus;
    }
}

