/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.usecase.recorder;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.anotheria.moskito.core.calltrace.CurrentlyTracedCall;
import net.anotheria.moskito.core.usecase.recorder.IUseCaseRecorder;
import net.anotheria.moskito.core.usecase.recorder.NoSuchRecordedUseCaseException;

public class UseCaseRecorderImpl
implements IUseCaseRecorder {
    private Map<String, CurrentlyTracedCall> recordedUseCases = new ConcurrentHashMap<String, CurrentlyTracedCall>();

    UseCaseRecorderImpl() {
    }

    @Override
    public void addRecordedUseCase(CurrentlyTracedCall useCase) {
        this.recordedUseCases.put(useCase.getName(), useCase);
    }

    @Override
    public CurrentlyTracedCall getRecordedUseCaseByName(String name) throws NoSuchRecordedUseCaseException {
        CurrentlyTracedCall useCase = this.recordedUseCases.get(name);
        if (useCase == null) {
            throw new NoSuchRecordedUseCaseException(name);
        }
        return useCase;
    }

    @Override
    public List<String> getRecordedUseCaseNames() {
        return new ArrayList<String>(this.recordedUseCases.keySet());
    }

    @Override
    public List<CurrentlyTracedCall> getRecordedUseCases() {
        return new ArrayList<CurrentlyTracedCall>(this.recordedUseCases.values());
    }

    @Override
    public void removeRecordedUseCaseByName(String name) {
        this.recordedUseCases.remove(name);
    }
}

