/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.util;

import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.ArrayList;
import java.util.List;
import java.util.TimerTask;
import net.anotheria.moskito.core.predefined.RuntimeStats;
import net.anotheria.moskito.core.producers.IStats;
import net.anotheria.moskito.core.producers.IStatsProducer;
import net.anotheria.moskito.core.registry.ProducerRegistryFactory;
import net.anotheria.moskito.core.util.AbstractBuiltInProducer;
import net.anotheria.moskito.core.util.BuiltInProducer;
import net.anotheria.moskito.core.util.BuiltinUpdater;

public class BuiltInRuntimeProducer
extends AbstractBuiltInProducer
implements IStatsProducer,
BuiltInProducer {
    private RuntimeStats stats;
    private List<IStats> statsList;
    private RuntimeMXBean mxBean = ManagementFactory.getRuntimeMXBean();

    public BuiltInRuntimeProducer() {
        this.statsList = new ArrayList<IStats>(1);
        this.stats = new RuntimeStats();
        this.statsList.add(this.stats);
        BuiltinUpdater.addTask(new TimerTask(){

            @Override
            public void run() {
                BuiltInRuntimeProducer.this.readMbean();
            }
        });
        ProducerRegistryFactory.getProducerRegistryInstance().registerProducer(this);
    }

    @Override
    public String getCategory() {
        return "runtime";
    }

    @Override
    public String getProducerId() {
        return "Runtime";
    }

    public List<IStats> getStats() {
        return this.statsList;
    }

    @Override
    public String getSubsystem() {
        return "builtin";
    }

    private void readMbean() {
        long starttime = this.mxBean.getStartTime();
        long uptime = this.mxBean.getUptime();
        String name = this.mxBean.getName();
        this.stats.update(name, starttime, uptime);
    }
}

