/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.util.storage;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import net.anotheria.moskito.core.inspection.CreationInfo;
import net.anotheria.moskito.core.inspection.Inspectable;
import net.anotheria.moskito.core.producers.IStatsProducer;
import net.anotheria.moskito.core.registry.IProducerRegistry;
import net.anotheria.moskito.core.registry.ProducerRegistryFactory;
import net.anotheria.moskito.core.util.storage.MapStorageWrapper;
import net.anotheria.moskito.core.util.storage.StorageStats;
import net.anotheria.moskito.core.util.storage.StorageWrapper;

public class Storage<K, V>
implements IStatsProducer<StorageStats>,
Inspectable,
Map<K, V> {
    public static final String DEF_CATEGORY = "storage";
    public static final String DEF_SUBSYSTEM = "default";
    private StorageWrapper<K, V> wrapper;
    private static AtomicInteger instanceCount = new AtomicInteger(0);
    private String name;
    private String category;
    private String subsystem;
    private StorageStats stats;
    private List<StorageStats> statsList;
    private CreationInfo creationInfo;

    public Storage(StorageWrapper<K, V> aWrapper) {
        this(DEF_CATEGORY, aWrapper);
    }

    public Storage(String aName, StorageWrapper<K, V> aWrapper) {
        this.name = aName + "-" + instanceCount.incrementAndGet();
        this.wrapper = aWrapper;
        this.stats = new StorageStats(this.name);
        this.statsList = new ArrayList<StorageStats>(1);
        this.statsList.add(this.stats);
        this.category = DEF_CATEGORY;
        this.subsystem = DEF_SUBSYSTEM;
        IProducerRegistry reg = ProducerRegistryFactory.getProducerRegistryInstance();
        reg.registerProducer(this);
        RuntimeException e = new RuntimeException();
        e.fillInStackTrace();
        this.creationInfo = new CreationInfo(e.getStackTrace());
    }

    @Override
    public V get(Object key) {
        Object v = this.wrapper.get(key);
        this.stats.addGet();
        if (v == null) {
            this.stats.addMissedGet();
        }
        return v;
    }

    @Override
    public V put(K key, V value) {
        V v = this.wrapper.put(key, value);
        this.stats.addPut();
        if (v == null) {
            this.stats.increaseSize();
        } else {
            this.stats.addOverwritePut();
        }
        return v;
    }

    @Override
    public int size() {
        int size = this.wrapper.size();
        this.stats.setSize(size);
        return size;
    }

    @Override
    public boolean isEmpty() {
        return this.wrapper.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        boolean ret = this.wrapper.containsKey(key);
        if (ret) {
            this.stats.addContainsKeyHit();
        } else {
            this.stats.addContainsKeyMiss();
        }
        return ret;
    }

    @Override
    public boolean containsValue(Object value) {
        boolean ret = this.wrapper.containsValue(value);
        if (ret) {
            this.stats.addContainsValueHit();
        } else {
            this.stats.addContainsValueMiss();
        }
        return ret;
    }

    @Override
    public V remove(Object key) {
        Object v = this.wrapper.remove(key);
        this.stats.addRemove();
        if (v == null) {
            this.stats.addNoopRemove();
        } else {
            this.stats.decreaseSize();
        }
        return v;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.wrapper.entrySet();
    }

    @Override
    public void putAll(Storage<? extends K, ? extends V> anotherStorage) {
        this.wrapper.putAll(super.getWrapper());
        this.stats.setSize(this.wrapper.size());
    }

    @Override
    public Set<K> keySet() {
        return this.wrapper.keySet();
    }

    public Collection<K> keys() {
        return this.wrapper.keys();
    }

    @Override
    public Collection<V> values() {
        return this.wrapper.values();
    }

    @Override
    public void clear() {
        this.wrapper.clear();
    }

    private StorageWrapper<K, V> getWrapper() {
        return this.wrapper;
    }

    public Map<K, V> toMap() {
        return this.wrapper.toMap();
    }

    public Map<K, V> fillMap(Map<K, V> toFill) {
        return this.wrapper.fillMap(toFill);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> anotherMap) {
        this.wrapper.putAll(anotherMap);
        this.stats.setSize(this.wrapper.size());
    }

    @Override
    public String getCategory() {
        return this.category;
    }

    @Override
    public String getProducerId() {
        return this.getName();
    }

    @Override
    public List<StorageStats> getStats() {
        return this.statsList;
    }

    @Override
    public String getSubsystem() {
        return this.subsystem;
    }

    public void setSubsystem(String aSubsystem) {
        this.subsystem = aSubsystem;
    }

    public void setCategory(String aCategory) {
        this.category = aCategory;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public CreationInfo getCreationInfo() {
        return this.creationInfo;
    }

    public static <K, V> Storage<K, V> createHashMapStorage() {
        return new Storage(new MapStorageWrapper(new HashMap()));
    }

    public static <K, V> Storage<K, V> createHashMapStorage(int initialSize) {
        return new Storage(new MapStorageWrapper(new HashMap(initialSize)));
    }

    public static <K, V> Storage<K, V> createHashMapStorage(String name) {
        return new Storage(name, new MapStorageWrapper(new HashMap()));
    }

    public static <K, V> Storage<K, V> createHashMapStorage(String name, int initialSize) {
        return new Storage(name, new MapStorageWrapper(new HashMap(initialSize)));
    }

    public static <K, V> Storage<K, V> createConcurrentHashMapStorage() {
        return new Storage(new MapStorageWrapper(new ConcurrentHashMap()));
    }

    public static <K, V> Storage<K, V> createConcurrentHashMapStorage(int initialSize) {
        return new Storage(new MapStorageWrapper(new ConcurrentHashMap(initialSize)));
    }

    public static <K, V> Storage<K, V> createConcurrentHashMapStorage(String name) {
        return new Storage(name, new MapStorageWrapper(new ConcurrentHashMap()));
    }

    public static <K, V> Storage<K, V> createConcurrentHashMapStorage(String name, int initialSize) {
        return new Storage(name, new MapStorageWrapper(new ConcurrentHashMap(initialSize)));
    }

    public static <K, V> Storage<K, V> createHashtableStorage() {
        return new Storage(new MapStorageWrapper(new Hashtable()));
    }

    public static <K, V> Storage<K, V> createHashtableStorage(int initialSize) {
        return new Storage(new MapStorageWrapper(new Hashtable(initialSize)));
    }

    public static <K, V> Storage<K, V> createHashtableStorage(String name) {
        return new Storage(name, new MapStorageWrapper(new Hashtable()));
    }

    public static <K, V> Storage<K, V> createHashtableStorage(String name, int initialSize) {
        return new Storage(name, new MapStorageWrapper(new Hashtable(initialSize)));
    }
}

