/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.util.threadhistory;

import net.anotheria.util.NumberUtils;

public class ThreadHistoryEvent {
    private long threadId;
    private String threadName;
    private OPERATION operation;
    private long timestamp;

    public ThreadHistoryEvent(long aThreadId, String aThreadName, OPERATION anOperation) {
        this.threadId = aThreadId;
        this.threadName = aThreadName;
        this.operation = anOperation;
        this.timestamp = System.currentTimeMillis();
    }

    public String toString() {
        return this.getNiceTimestamp() + " " + this.getThreadId() + " " + this.getThreadName() + " " + (Object)((Object)this.getOperation());
    }

    public long getThreadId() {
        return this.threadId;
    }

    public String getThreadName() {
        return this.threadName;
    }

    public OPERATION getOperation() {
        return this.operation;
    }

    public static final ThreadHistoryEvent created(long threadId, String threadName) {
        return new ThreadHistoryEvent(threadId, threadName, OPERATION.CREATED);
    }

    public static final ThreadHistoryEvent deleted(long threadId, String threadName) {
        return new ThreadHistoryEvent(threadId, threadName, OPERATION.DELETED);
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getNiceTimestamp() {
        return NumberUtils.makeISO8601TimestampString((long)this.getTimestamp());
    }

    public static enum OPERATION {
        CREATED,
        DELETED;

    }
}

