/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.dynamic;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import net.anotheria.moskito.core.dynamic.IOnDemandCallHandler;
import net.anotheria.moskito.core.dynamic.IOnDemandStatsFactory;
import net.anotheria.moskito.core.dynamic.MoskitoInvokationProxy;
import net.anotheria.moskito.core.predefined.ServiceStatsCallHandler;
import net.anotheria.moskito.core.predefined.ServiceStatsFactory;

public class ProxyUtils {
    private static ConcurrentMap<String, AtomicInteger> instanceCounters = new ConcurrentHashMap<String, AtomicInteger>();

    public static <T> T createInstance(T impl, String name, String category, String subsystem, IOnDemandCallHandler handler, IOnDemandStatsFactory statsFactory, Class<T> interf, Class<?> ... additionalInterfaces) {
        if (name == null) {
            name = ProxyUtils.extractName(interf);
        }
        Class[] interfacesParameter = new Class[additionalInterfaces == null ? 1 : 1 + additionalInterfaces.length];
        interfacesParameter[0] = interf;
        if (additionalInterfaces != null) {
            for (int i = 0; i < additionalInterfaces.length; ++i) {
                interfacesParameter[i + 1] = additionalInterfaces[i];
            }
        }
        MoskitoInvokationProxy proxy = new MoskitoInvokationProxy(impl, handler, statsFactory, name + "-" + ProxyUtils.getInstanceCounter(name), category, subsystem, interfacesParameter);
        Object ret = proxy.createProxy();
        return (T)ret;
    }

    public static <T> T createServiceInstance(T impl, String name, String category, String subsystem, Class<T> interf, Class<?> ... additionalInterfaces) {
        return ProxyUtils.createInstance(impl, name, category, subsystem, new ServiceStatsCallHandler(), new ServiceStatsFactory(), interf, additionalInterfaces);
    }

    public static <T> T createServiceInstance(T impl, String category, String subsystem, Class<T> interf, Class<?> ... additionalInterfaces) {
        return ProxyUtils.createServiceInstance(impl, null, category, subsystem, interf, additionalInterfaces);
    }

    public static <T> T createServiceInstance(T impl, String subsystem, Class<T> interf, Class<?> ... additionalInterfaces) {
        return ProxyUtils.createServiceInstance(impl, null, "service", subsystem, interf, additionalInterfaces);
    }

    public static <T> T createDAOInstance(T impl, String subsystem, Class<T> interf, Class<?> ... additionalInterfaces) {
        return ProxyUtils.createServiceInstance(impl, null, "dao", subsystem, interf, additionalInterfaces);
    }

    private static int getInstanceCounter(String name) {
        AtomicInteger counter = (AtomicInteger)instanceCounters.get(name);
        if (counter != null) {
            return counter.incrementAndGet();
        }
        counter = new AtomicInteger(0);
        AtomicInteger old = instanceCounters.putIfAbsent(name, counter);
        if (old != null) {
            counter = old;
        }
        return counter.incrementAndGet();
    }

    private static final String extractName(Class<?> clazz) {
        int indexOfDot;
        String name = clazz.getName();
        if (name == null) {
            name = "";
        }
        return (indexOfDot = name.lastIndexOf(46)) == -1 ? name : name.substring(indexOfDot + 1);
    }
}

