/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.predefined;

import net.anotheria.moskito.core.predefined.Constants;
import net.anotheria.moskito.core.producers.AbstractStats;
import net.anotheria.moskito.core.stats.Interval;
import net.anotheria.moskito.core.stats.StatValue;
import net.anotheria.moskito.core.stats.TimeUnit;
import net.anotheria.moskito.core.stats.impl.StatValueFactory;

public class MemoryStats
extends AbstractStats {
    private StatValue current;
    private StatValue min;
    private StatValue max;
    private static final long MB = 0x100000L;

    public MemoryStats() {
        this("unnamed", Constants.getDefaultIntervals());
    }

    public MemoryStats(String aName) {
        this(aName, Constants.getDefaultIntervals());
    }

    public MemoryStats(String aName, Interval[] selectedIntervals) {
        super(aName);
        this.current = StatValueFactory.createStatValue(0L, "current", selectedIntervals);
        this.min = StatValueFactory.createStatValue(0L, "min", selectedIntervals);
        this.max = StatValueFactory.createStatValue(0L, "max", selectedIntervals);
        this.addStatValues(this.current, this.min, this.max);
    }

    @Override
    public String toStatsString(String intervalName, TimeUnit timeUnit) {
        StringBuilder b = new StringBuilder();
        b.append(this.getName()).append(' ');
        b.append(" CUR: ").append(this.current.getValueAsLong(intervalName));
        b.append(" MIN: ").append(this.min.getValueAsLong(intervalName));
        b.append(" MAX: ").append(this.max.getValueAsLong(intervalName));
        return b.toString();
    }

    public void updateMemoryValue(long value) {
        this.current.setValueAsLong(value);
        this.min.setValueIfLesserThanCurrentAsLong(value);
        this.max.setValueIfGreaterThanCurrentAsLong(value);
    }

    public long getCurrent(String intervalName) {
        return this.current.getValueAsLong(intervalName);
    }

    public long getMin(String intervalName) {
        return this.min.getValueAsLong(intervalName);
    }

    public long getMax(String intervalName) {
        return this.max.getValueAsLong(intervalName);
    }

    @Override
    public String getValueByNameAsString(String valueName, String intervalName, TimeUnit timeUnit) {
        if (valueName == null || valueName.equals("")) {
            throw new AssertionError((Object)"Value name can not be empty");
        }
        if ((valueName = valueName.toLowerCase()).equals("current") || valueName.equals("cur")) {
            return "" + this.getCurrent(intervalName);
        }
        if (valueName.equals("current mb") || valueName.equals("cur mb")) {
            return "" + this.getCurrent(intervalName) / 0x100000L;
        }
        if (valueName.equals("min")) {
            return "" + this.getMin(intervalName);
        }
        if (valueName.equals("min mb")) {
            return "" + this.getMin(intervalName) / 0x100000L;
        }
        if (valueName.equals("max")) {
            return "" + this.getMax(intervalName);
        }
        if (valueName.equals("max mb")) {
            return "" + this.getMax(intervalName) / 0x100000L;
        }
        return super.getValueByNameAsString(valueName, intervalName, timeUnit);
    }
}

