/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.predefined;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.anotheria.moskito.core.producers.AbstractStats;
import net.anotheria.moskito.core.stats.Interval;
import net.anotheria.moskito.core.stats.StatValue;
import net.anotheria.moskito.core.stats.TimeUnit;
import net.anotheria.moskito.core.stats.impl.StatValueFactory;
import net.anotheria.util.StringUtils;

public class PageInBrowserStats
extends AbstractStats {
    private String url;
    private StatValue domMinLoadTime;
    private StatValue domMaxLoadTime;
    private StatValue domLastLoadTime;
    private StatValue totalDomLoadTime;
    private StatValue windowMinLoadTime;
    private StatValue windowMaxLoadTime;
    private StatValue windowLastLoadTime;
    private StatValue totalWindowLoadTime;
    private StatValue numberOfLoads;
    private static final List<String> VALUE_NAMES = Collections.unmodifiableList(PageInBrowserStatsValueName.getValueNames());

    public PageInBrowserStats(String urlPath, Interval[] selectedIntervals) {
        this.url = urlPath;
        long pattern = 0L;
        Interval[] intervals = Arrays.copyOf(selectedIntervals, selectedIntervals.length);
        this.domMinLoadTime = StatValueFactory.createStatValue(0L, "domMinLoadTime", intervals);
        this.domMaxLoadTime = StatValueFactory.createStatValue(0L, "domMaxLoadTime", intervals);
        this.domLastLoadTime = StatValueFactory.createStatValue(0L, "domLastLoadTime", intervals);
        this.totalDomLoadTime = StatValueFactory.createStatValue(0L, "totalDomLoadTime", intervals);
        this.windowMinLoadTime = StatValueFactory.createStatValue(0L, "windowMinLoadTime", intervals);
        this.windowMaxLoadTime = StatValueFactory.createStatValue(0L, "windowMaxLoadTime", intervals);
        this.windowLastLoadTime = StatValueFactory.createStatValue(0L, "windowLastLoadTime", intervals);
        this.totalWindowLoadTime = StatValueFactory.createStatValue(0L, "totalWindowLoadTime", intervals);
        this.numberOfLoads = StatValueFactory.createStatValue(0L, "numberOfLoads", intervals);
        this.domMinLoadTime.setDefaultValueAsLong(Long.MAX_VALUE);
        this.domMinLoadTime.reset();
        this.domMaxLoadTime.setDefaultValueAsLong(Long.MIN_VALUE);
        this.domMaxLoadTime.reset();
        this.windowMinLoadTime.setDefaultValueAsLong(Long.MAX_VALUE);
        this.windowMinLoadTime.reset();
        this.windowMaxLoadTime.setDefaultValueAsLong(Long.MIN_VALUE);
        this.windowMaxLoadTime.reset();
    }

    public void addLoadTime(long domLoadTime, long windowLoadTime) {
        this.totalDomLoadTime.increaseByLong(domLoadTime);
        this.domMinLoadTime.setValueIfLesserThanCurrentAsLong(domLoadTime);
        this.domMaxLoadTime.setValueIfGreaterThanCurrentAsLong(domLoadTime);
        this.domLastLoadTime.setValueAsLong(domLoadTime);
        this.totalWindowLoadTime.increaseByLong(windowLoadTime);
        this.windowMinLoadTime.setValueIfLesserThanCurrentAsLong(windowLoadTime);
        this.windowMaxLoadTime.setValueIfGreaterThanCurrentAsLong(windowLoadTime);
        this.windowLastLoadTime.setValueAsLong(windowLoadTime);
        this.numberOfLoads.increase();
    }

    @Override
    public String getName() {
        return this.url;
    }

    public long getDomMinLoadTime(String intervalName, TimeUnit unit) {
        long min = this.domMinLoadTime.getValueAsLong(intervalName);
        return min == Long.MAX_VALUE ? min : unit.transformMillis(min);
    }

    public long getDomMaxLoadTime(String intervalName, TimeUnit unit) {
        long max = this.domMaxLoadTime.getValueAsLong(intervalName);
        return max == Long.MIN_VALUE ? max : unit.transformMillis(max);
    }

    public long getDomLastLoadTime(String intervalName, TimeUnit unit) {
        return unit.transformMillis(this.domLastLoadTime.getValueAsLong(intervalName));
    }

    public long getTotalDomLoadTime(String intervalName, TimeUnit unit) {
        return unit.transformMillis(this.totalDomLoadTime.getValueAsLong(intervalName));
    }

    public long getWindowMinLoadTime(String intervalName, TimeUnit unit) {
        long min = this.windowMinLoadTime.getValueAsLong(intervalName);
        return min == Long.MAX_VALUE ? min : unit.transformMillis(min);
    }

    public long getWindowMaxLoadTime(String intervalName, TimeUnit unit) {
        long max = this.windowMaxLoadTime.getValueAsLong(intervalName);
        return max == Long.MIN_VALUE ? max : unit.transformMillis(max);
    }

    public long getWindowLastLoadTime(String intervalName, TimeUnit unit) {
        return unit.transformMillis(this.windowLastLoadTime.getValueAsLong(intervalName));
    }

    public double getAverageDOMLoadTime(String intervalName, TimeUnit unit) {
        return (double)unit.transformMillis(this.totalDomLoadTime.getValueAsLong(intervalName)) / this.numberOfLoads.getValueAsDouble(intervalName);
    }

    public double getAverageWindowLoadTime(String intervalName, TimeUnit unit) {
        return (double)unit.transformMillis(this.totalWindowLoadTime.getValueAsLong(intervalName)) / this.numberOfLoads.getValueAsDouble(intervalName);
    }

    public long getTotalWindowLoadTime(String intervalName, TimeUnit unit) {
        return unit.transformMillis(this.totalWindowLoadTime.getValueAsLong(intervalName));
    }

    public long getNumberOfLoads() {
        return this.numberOfLoads.getValueAsLong();
    }

    @Override
    public String toStatsString(String intervalName, TimeUnit unit) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.url);
        if (this.getDomMinLoadTime(intervalName, unit) == Long.MAX_VALUE) {
            builder.append(this.toFormattedStatsString(PageInBrowserStatsValueName.DOM_MIN, "NoR"));
        } else {
            builder.append(this.toFormattedStatsString(PageInBrowserStatsValueName.DOM_MIN, String.valueOf(this.getDomMinLoadTime(intervalName, unit))));
        }
        if (this.getDomMaxLoadTime(intervalName, unit) == Long.MIN_VALUE) {
            builder.append(this.toFormattedStatsString(PageInBrowserStatsValueName.DOM_MAX, "NoR"));
        } else {
            builder.append(this.toFormattedStatsString(PageInBrowserStatsValueName.DOM_MAX, String.valueOf(this.getDomMaxLoadTime(intervalName, unit))));
        }
        builder.append(this.toFormattedStatsString(PageInBrowserStatsValueName.DOM_AVG, String.valueOf(this.getAverageDOMLoadTime(intervalName, unit))));
        builder.append(this.toFormattedStatsString(PageInBrowserStatsValueName.DOM_LAST, String.valueOf(this.getDomLastLoadTime(intervalName, unit))));
        if (this.getWindowMinLoadTime(intervalName, unit) == Long.MAX_VALUE) {
            builder.append(this.toFormattedStatsString(PageInBrowserStatsValueName.WIN_MIN, "NoR"));
        } else {
            builder.append(this.toFormattedStatsString(PageInBrowserStatsValueName.WIN_MIN, String.valueOf(this.getWindowMinLoadTime(intervalName, unit))));
        }
        if (this.getWindowMaxLoadTime(intervalName, unit) == Long.MIN_VALUE) {
            builder.append(this.toFormattedStatsString(PageInBrowserStatsValueName.WIN_MAX, "NoR"));
        } else {
            builder.append(this.toFormattedStatsString(PageInBrowserStatsValueName.WIN_MAX, String.valueOf(this.getWindowMaxLoadTime(intervalName, unit))));
        }
        builder.append(this.toFormattedStatsString(PageInBrowserStatsValueName.WIN_AVG, String.valueOf(this.getAverageWindowLoadTime(intervalName, unit))));
        builder.append(this.toFormattedStatsString(PageInBrowserStatsValueName.WIN_LAST, String.valueOf(this.getWindowLastLoadTime(intervalName, unit))));
        return builder.toString();
    }

    private String toFormattedStatsString(PageInBrowserStatsValueName valueName, String value) {
        return " " + valueName.getValueName() + ": " + value;
    }

    @Override
    public String getValueByNameAsString(String valueName, String intervalName, TimeUnit timeUnit) {
        if (StringUtils.isEmpty((String)valueName)) {
            throw new AssertionError((Object)"Value name can not be empty");
        }
        PageInBrowserStatsValueName statsValueName = PageInBrowserStatsValueName.getByName(valueName);
        switch (statsValueName) {
            case DOM_MIN: {
                return String.valueOf(this.getDomMinLoadTime(intervalName, timeUnit));
            }
            case DOM_MAX: {
                return String.valueOf(this.getDomMaxLoadTime(intervalName, timeUnit));
            }
            case DOM_AVG: {
                return String.valueOf(this.getAverageDOMLoadTime(intervalName, timeUnit));
            }
            case DOM_LAST: {
                return String.valueOf(this.getDomLastLoadTime(intervalName, timeUnit));
            }
            case WIN_MIN: {
                return String.valueOf(this.getWindowMinLoadTime(intervalName, timeUnit));
            }
            case WIN_MAX: {
                return String.valueOf(this.getWindowMaxLoadTime(intervalName, timeUnit));
            }
            case WIN_AVG: {
                return String.valueOf(this.getAverageWindowLoadTime(intervalName, timeUnit));
            }
            case WIN_LAST: {
                return String.valueOf(this.getWindowLastLoadTime(intervalName, timeUnit));
            }
            case NUMBER_OF_LOADS: {
                return String.valueOf(this.getNumberOfLoads());
            }
            case TOTAL_DOM: {
                return String.valueOf(this.getTotalDomLoadTime(intervalName, timeUnit));
            }
            case TOTAL_WIN: {
                return String.valueOf(this.getTotalWindowLoadTime(intervalName, timeUnit));
            }
        }
        return super.getValueByNameAsString(valueName, intervalName, timeUnit);
    }

    @Override
    public List<String> getAvailableValueNames() {
        return VALUE_NAMES;
    }

    public static enum PageInBrowserStatsValueName {
        DOM_MIN("DomMin"),
        DOM_MAX("DomMax"),
        DOM_AVG("DOMAvg"),
        DOM_LAST("DOMLast"),
        WIN_MIN("WinMin"),
        WIN_MAX("WinMax"),
        WIN_AVG("WinAvg"),
        WIN_LAST("WinLast"),
        TOTAL_DOM("TotalDOM"),
        TOTAL_WIN("TotalWindow"),
        NUMBER_OF_LOADS("Count"),
        DEFAULT("default");

        private String valueName;

        private PageInBrowserStatsValueName(String valueName) {
            this.valueName = valueName;
        }

        public String getValueName() {
            return this.valueName;
        }

        public static PageInBrowserStatsValueName getByName(String name) {
            for (PageInBrowserStatsValueName valueName : PageInBrowserStatsValueName.values()) {
                if (!valueName.name().equalsIgnoreCase(name)) continue;
                return valueName;
            }
            return DEFAULT;
        }

        public static List<String> getValueNames() {
            ArrayList<String> valueNames = new ArrayList<String>(PageInBrowserStatsValueName.values().length);
            for (PageInBrowserStatsValueName valueName : PageInBrowserStatsValueName.values()) {
                valueNames.add(valueName.getValueName());
            }
            return valueNames;
        }
    }
}

