/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.predefined;

import java.util.ArrayList;
import java.util.List;
import net.anotheria.moskito.core.predefined.Constants;
import net.anotheria.moskito.core.producers.AbstractStats;
import net.anotheria.moskito.core.stats.Interval;
import net.anotheria.moskito.core.stats.StatValue;
import net.anotheria.moskito.core.stats.TimeUnit;
import net.anotheria.moskito.core.stats.impl.StatValueFactory;

public class QueuingSystemStats
extends AbstractStats {
    public static final long MIN_SIZE_DEFAULT = Long.MAX_VALUE;
    public static final long MAX_SIZE_DEFAULT = 0L;
    private StatValue serversSize;
    private StatValue queueSize;
    private StatValue arrived;
    private StatValue serviced;
    private StatValue errors;
    private StatValue waited;
    private StatValue throwedAway;
    private StatValue waitingTime;
    private StatValue waitingTimeMin;
    private StatValue waitingTimeMax;
    private StatValue servicingTime;
    private StatValue servicingTimeMin;
    private StatValue servicingTimeMax;
    private String name;

    public QueuingSystemStats() {
        this("unnamed", Constants.getDefaultIntervals());
    }

    public QueuingSystemStats(String name) {
        this(name, Constants.getDefaultIntervals());
    }

    public QueuingSystemStats(String aName, Interval[] selectedIntervals) {
        Long longPattern = 0L;
        this.name = aName;
        this.serversSize = StatValueFactory.createStatValue(longPattern, "serversSize", selectedIntervals);
        this.queueSize = StatValueFactory.createStatValue(longPattern, "queueSize", selectedIntervals);
        this.arrived = StatValueFactory.createStatValue(longPattern, "arrived", selectedIntervals);
        this.serviced = StatValueFactory.createStatValue(longPattern, "serviced", selectedIntervals);
        this.errors = StatValueFactory.createStatValue(longPattern, "errors", selectedIntervals);
        this.waited = StatValueFactory.createStatValue(longPattern, "waited", selectedIntervals);
        this.throwedAway = StatValueFactory.createStatValue(longPattern, "throwedAway", selectedIntervals);
        this.waitingTime = StatValueFactory.createStatValue(longPattern, "waitingTime", selectedIntervals);
        this.waitingTimeMin = StatValueFactory.createStatValue(longPattern, "waitingTimeMin", selectedIntervals);
        this.waitingTimeMin.setDefaultValueAsLong(Long.MAX_VALUE);
        this.waitingTimeMin.reset();
        this.waitingTimeMax = StatValueFactory.createStatValue(longPattern, "waitingTimeMax", selectedIntervals);
        this.waitingTimeMax.setDefaultValueAsLong(Long.MIN_VALUE);
        this.waitingTimeMax.reset();
        this.servicingTime = StatValueFactory.createStatValue(longPattern, "servicingTime", selectedIntervals);
        this.servicingTimeMin = StatValueFactory.createStatValue(longPattern, "servicingTimeMin", selectedIntervals);
        this.servicingTimeMin.setDefaultValueAsLong(Long.MAX_VALUE);
        this.servicingTimeMin.reset();
        this.servicingTimeMax = StatValueFactory.createStatValue(longPattern, "servicingTimeMax", selectedIntervals);
        this.servicingTimeMax.setDefaultValueAsLong(Long.MIN_VALUE);
        this.servicingTimeMax.reset();
        this.addStatValues(this.serversSize, this.queueSize, this.arrived, this.serviced, this.errors, this.waited, this.throwedAway, this.waitingTime, this.waitingTimeMin, this.waitingTimeMax, this.servicingTime, this.servicingTimeMin, this.servicingTimeMax);
    }

    public void setServersSize(int size) {
        this.serversSize.setValueAsLong(size);
    }

    public long getServersSize(String intervalName) {
        return this.serversSize.getValueAsLong();
    }

    public void setQueueSize(int size) {
        this.queueSize.setValueAsLong(size);
    }

    public long getQueueSize(String intervalName) {
        return this.queueSize.getValueAsLong();
    }

    public void addArrived() {
        this.arrived.increase();
    }

    public long getArrived(String intervalName) {
        return this.arrived.getValueAsLong(intervalName);
    }

    public void addServiced() {
        this.serviced.increase();
    }

    public long getServiced(String intervalName) {
        return this.serviced.getValueAsLong(intervalName);
    }

    public void addError() {
        this.errors.increase();
    }

    public long getErrors(String intervalName) {
        return this.errors.getValueAsLong(intervalName);
    }

    public void addWaited() {
        this.waited.increase();
    }

    public long getWaited(String intervalName) {
        return this.waited.getValueAsLong(intervalName);
    }

    public void addThrowedAway() {
        this.throwedAway.increase();
    }

    public long getThrowedAway(String intervalName) {
        return this.throwedAway.getValueAsLong(intervalName);
    }

    public void addWaitingTime(long time) {
        this.waitingTime.increaseByLong(time);
        this.waitingTimeMin.setValueIfLesserThanCurrentAsLong(time);
        this.waitingTimeMax.setValueIfGreaterThanCurrentAsLong(time);
    }

    public long getWaitingTime(String intervalName) {
        return this.waitingTime.getValueAsLong(intervalName);
    }

    public long getWaitingTimeMin(String intervalName) {
        return this.waitingTimeMin.getValueAsLong(intervalName);
    }

    public long getWaitingTimeMax(String intervalName) {
        return this.waitingTimeMax.getValueAsLong(intervalName);
    }

    public long getWaitingTimeAverage(String intervalName) {
        long waitedVal = this.waited.getValueAsLong(intervalName);
        return waitedVal > 0L ? this.waitingTime.getValueAsLong(intervalName) / waitedVal : -1L;
    }

    public void addServicingTime(long time) {
        this.servicingTime.increaseByLong(time);
        this.servicingTimeMin.setValueIfLesserThanCurrentAsLong(time);
        this.servicingTimeMax.setValueIfGreaterThanCurrentAsLong(time);
    }

    public long getServicingTime(String intervalName) {
        return this.servicingTime.getValueAsLong(intervalName);
    }

    public long getServicingTimeMin(String intervalName) {
        return this.servicingTimeMin.getValueAsLong(intervalName);
    }

    public long getServicingTimeMax(String intervalName) {
        return this.servicingTimeMax.getValueAsLong(intervalName);
    }

    public long getServicingTimeAverage(String intervalName) {
        long servicedVal = this.serviced.getValueAsLong(intervalName);
        return servicedVal > 0L ? this.servicingTime.getValueAsLong(intervalName) / servicedVal : -1L;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<String> getAvailableValueNames() {
        return StatDef.getStatNames();
    }

    private String transformMinTimeNanos(long minTime, TimeUnit timeUnit) {
        if (minTime == Long.MAX_VALUE) {
            return "NoR";
        }
        return "" + timeUnit.transformNanos(minTime);
    }

    private String transformMaxTimeNanos(long maxTime, TimeUnit timeUnit) {
        if (maxTime == Long.MIN_VALUE) {
            return "NoR";
        }
        return "" + timeUnit.transformNanos(maxTime);
    }

    private String transformAverageTimeNanos(long maxTime, TimeUnit timeUnit) {
        if (maxTime == -1L) {
            return "NoR";
        }
        return "" + timeUnit.transformNanos(maxTime);
    }

    @Override
    public String toStatsString(String intervalName, TimeUnit timeUnit) {
        StringBuilder b = new StringBuilder();
        b.append(this.getName()).append(' ');
        b.append(StatDef.SERVERS_SIZE.getStatLabel()).append(this.getServersSize(intervalName));
        b.append(StatDef.QUEUE_SIZE.getStatLabel()).append(this.getQueueSize(intervalName));
        b.append(StatDef.ARRIVED.getStatLabel()).append(this.getArrived(intervalName));
        b.append(StatDef.SERVICED.getStatLabel()).append(this.getServiced(intervalName));
        b.append(StatDef.ERRORS.getStatLabel()).append(this.getErrors(intervalName));
        b.append(StatDef.WAITED.getStatLabel()).append(this.getWaited(intervalName));
        b.append(StatDef.THROWN_AWAY.getStatLabel()).append(this.getThrowedAway(intervalName));
        b.append(StatDef.WAITING_TIME.getStatLabel()).append(timeUnit.transformNanos(this.getWaitingTime(intervalName)));
        b.append(StatDef.WAITING_TIME_MIN.getStatLabel()).append(this.transformMinTimeNanos(this.getWaitingTimeMin(intervalName), timeUnit));
        b.append(StatDef.WAITING_TIME_MAX.getStatLabel()).append(this.transformMaxTimeNanos(this.getWaitingTimeMax(intervalName), timeUnit));
        b.append(StatDef.WAITING_TIME_AVG.getStatLabel()).append(this.transformAverageTimeNanos(this.getWaitingTimeAverage(intervalName), timeUnit));
        b.append(StatDef.SERVICE_TIME.getStatLabel()).append(timeUnit.transformNanos(this.getServicingTime(intervalName)));
        b.append(StatDef.SERVICE_TIME_MIN.getStatLabel()).append(this.transformMinTimeNanos(this.getServicingTimeMin(intervalName), timeUnit));
        b.append(StatDef.SERVICE_TIME_MAX.getStatLabel()).append(this.transformMaxTimeNanos(this.getServicingTimeMax(intervalName), timeUnit));
        b.append(StatDef.SERVICE_TIME_AVG.getStatLabel()).append(this.transformAverageTimeNanos(this.getServicingTimeAverage(intervalName), timeUnit));
        return b.toString();
    }

    @Override
    public String getValueByNameAsString(String valueName, String intervalName, TimeUnit timeUnit) {
        if (valueName == null || valueName.equals("")) {
            throw new AssertionError((Object)"Value name can not be empty");
        }
        if (valueName.equals(StatDef.SERVERS_SIZE.getStatName())) {
            return "" + this.getServersSize(intervalName);
        }
        if (valueName.equals(StatDef.QUEUE_SIZE.getStatName())) {
            return "" + this.getQueueSize(intervalName);
        }
        if (valueName.equals(StatDef.ARRIVED.getStatName())) {
            return "" + this.getArrived(intervalName);
        }
        if (valueName.equals(StatDef.SERVICED.getStatName())) {
            return "" + this.getServiced(intervalName);
        }
        if (valueName.equals(StatDef.ERRORS.getStatName())) {
            return "" + this.getErrors(intervalName);
        }
        if (valueName.equals(StatDef.WAITED.getStatName())) {
            return "" + this.getWaited(intervalName);
        }
        if (valueName.equals(StatDef.THROWN_AWAY.getStatName())) {
            return "" + this.getThrowedAway(intervalName);
        }
        if (valueName.equals(StatDef.WAITING_TIME.getStatName())) {
            return "" + timeUnit.transformNanos(this.getWaitingTime(intervalName));
        }
        if (valueName.equals(StatDef.WAITING_TIME_MIN.getStatName())) {
            return this.transformMinTimeNanos(this.getWaitingTimeMin(intervalName), timeUnit);
        }
        if (valueName.equals(StatDef.WAITING_TIME_MAX.getStatName())) {
            return this.transformMaxTimeNanos(this.getWaitingTimeMax(intervalName), timeUnit);
        }
        if (valueName.equals(StatDef.WAITING_TIME_AVG.getStatName())) {
            return this.transformAverageTimeNanos(this.getWaitingTimeAverage(intervalName), timeUnit);
        }
        if (valueName.equals(StatDef.SERVICE_TIME.getStatName())) {
            return "" + timeUnit.transformNanos(this.getServicingTime(intervalName));
        }
        if (valueName.equals(StatDef.SERVICE_TIME_MIN.getStatName())) {
            return this.transformMinTimeNanos(this.getServicingTimeMin(intervalName), timeUnit);
        }
        if (valueName.equals(StatDef.SERVICE_TIME_MAX.getStatName())) {
            return this.transformMaxTimeNanos(this.getServicingTimeMax(intervalName), timeUnit);
        }
        if (valueName.equals(StatDef.SERVICE_TIME_AVG.getStatName())) {
            return this.transformAverageTimeNanos(this.getServicingTimeAverage(intervalName), timeUnit);
        }
        return super.getValueByNameAsString(valueName, intervalName, timeUnit);
    }

    static enum StatDef {
        SERVERS_SIZE("SS"),
        QUEUE_SIZE("QS"),
        ARRIVED("Arr"),
        SERVICED("Serv"),
        ERRORS("Err"),
        WAITED("Wait"),
        THROWN_AWAY("Thr"),
        WAITING_TIME("WT"),
        WAITING_TIME_MIN("WTm"),
        WAITING_TIME_MAX("WTM"),
        WAITING_TIME_AVG("WTA"),
        SERVICE_TIME("ST"),
        SERVICE_TIME_MIN("STm"),
        SERVICE_TIME_MAX("STM"),
        SERVICE_TIME_AVG("STA");

        private String statName;

        private StatDef(String aStatName) {
            this.statName = aStatName;
        }

        public String getStatName() {
            return this.statName;
        }

        public String getStatLabel() {
            return " " + this.statName + ": ";
        }

        public static List<String> getStatNames() {
            ArrayList<String> ret = new ArrayList<String>(StatDef.values().length);
            for (StatDef v : StatDef.values()) {
                ret.add(v.getStatName());
            }
            return ret;
        }
    }
}

