/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.stats.impl;

import java.util.concurrent.atomic.AtomicLong;
import net.anotheria.moskito.core.stats.Interval;
import net.anotheria.moskito.core.stats.impl.AbstractValueHolder;

class LongValueHolder
extends AbstractValueHolder {
    public static final long DEFAULT_DEFAULT_VALUE = 0L;
    private AtomicLong currentValue = new AtomicLong(this.defaultValue);
    private long lastValue;
    private long defaultValue = 0L;

    public LongValueHolder(Interval aInterval) {
        super(aInterval);
    }

    @Override
    public void intervalUpdated(Interval caller) {
        this.lastValue = this.currentValue.getAndSet(this.defaultValue);
    }

    protected void updateLastValueFromCurrent() {
        this.lastValue = this.currentValue.get();
    }

    public long getLastValue() {
        return this.lastValue;
    }

    @Override
    public String toString() {
        return super.toString() + " L " + this.lastValue + " / " + this.currentValue.get();
    }

    @Override
    public void decrease() {
        this.currentValue.decrementAndGet();
    }

    @Override
    public void increase() {
        this.currentValue.incrementAndGet();
    }

    @Override
    public void decreaseByDouble(double aValue) {
        this.decreaseByLong((long)aValue);
    }

    @Override
    public void decreaseByInt(int aValue) {
        this.decreaseByLong(aValue);
    }

    @Override
    public void decreaseByLong(long aValue) {
        this.currentValue.addAndGet(-aValue);
    }

    @Override
    public double getValueAsDouble() {
        return this.getValueAsLong();
    }

    @Override
    public int getValueAsInt() {
        return (int)this.getValueAsLong();
    }

    @Override
    public long getValueAsLong() {
        return this.lastValue;
    }

    @Override
    public void increaseByDouble(double aValue) {
        this.increaseByLong((long)aValue);
    }

    @Override
    public void increaseByInt(int aValue) {
        this.increaseByLong(aValue);
    }

    @Override
    public void increaseByLong(long aValue) {
        this.currentValue.addAndGet(aValue);
    }

    @Override
    public void setValueAsDouble(double aValue) {
        this.setValueAsLong((long)aValue);
    }

    @Override
    public void setValueAsInt(int aValue) {
        this.setValueAsLong(aValue);
    }

    @Override
    public void setValueAsLong(long aValue) {
        this.currentValue.set(aValue);
    }

    @Override
    public void setDefaultValueAsLong(long aValue) {
        this.defaultValue = aValue;
    }

    @Override
    public void setDefaultValueAsInt(int aValue) {
        this.setDefaultValueAsLong(aValue);
    }

    @Override
    public void setDefaultValueAsDouble(double aValue) {
        this.setDefaultValueAsLong((long)aValue);
    }

    @Override
    public void reset() {
        this.currentValue.set(this.defaultValue);
        this.lastValue = this.defaultValue;
    }

    @Override
    public double getCurrentValueAsDouble() {
        return this.getCurrentValueAsLong();
    }

    @Override
    public int getCurrentValueAsInt() {
        return (int)this.getCurrentValueAsLong();
    }

    @Override
    public long getCurrentValueAsLong() {
        return this.currentValue.get();
    }

    @Override
    public void setValueAsString(String aValue) {
        this.currentValue.set(Long.parseLong(aValue));
    }

    @Override
    public String getValueAsString() {
        return "" + this.lastValue;
    }

    @Override
    public String getCurrentValueAsString() {
        return "" + this.currentValue.get();
    }

    protected void setLastValue(long aValue) {
        this.lastValue = aValue;
    }
}

