/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.usecase;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.anotheria.moskito.core.calltrace.CurrentlyTracedCall;
import net.anotheria.moskito.core.usecase.UseCasePath;

public class UseCase {
    private List<UseCasePath> _cachedPathesList;
    private final Map<String, UseCasePath> pathes;
    private String name;

    public UseCase(String aName) {
        this.name = aName;
        this.pathes = new HashMap<String, UseCasePath>();
        this._cachedPathesList = new ArrayList<UseCasePath>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addExecution(CurrentlyTracedCall finishedUseCase) {
        String path = finishedUseCase.getTrace();
        UseCasePath useCasePath = this.pathes.get(path);
        if (useCasePath == null) {
            Map<String, UseCasePath> map = this.pathes;
            synchronized (map) {
                useCasePath = this.pathes.get(path);
                if (useCasePath == null) {
                    useCasePath = new UseCasePath(path);
                    this.pathes.put(path, useCasePath);
                    this.rebuildCachedPathList();
                }
            }
        }
        useCasePath.addProcessedUseCase();
    }

    private void rebuildCachedPathList() {
        this._cachedPathesList = new ArrayList<UseCasePath>(this.pathes.size());
        Iterator<UseCasePath> i = this.pathes.values().iterator();
        while (i.hasNext()) {
            this._cachedPathesList.add(i.next());
        }
    }

    public List<UseCasePath> getCachedPathList() {
        return this._cachedPathesList;
    }

    public String toString() {
        return this.getName() + ": " + this._cachedPathesList.toString();
    }

    public String getName() {
        return this.name;
    }
}

