/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.util;

import java.util.List;
import java.util.TimerTask;
import java.util.concurrent.CopyOnWriteArrayList;
import net.anotheria.moskito.core.predefined.MemoryStats;
import net.anotheria.moskito.core.producers.IStats;
import net.anotheria.moskito.core.producers.IStatsProducer;
import net.anotheria.moskito.core.util.AbstractBuiltInProducer;
import net.anotheria.moskito.core.util.BuiltInProducer;
import net.anotheria.moskito.core.util.BuiltinUpdater;

public class BuiltInMemoryProducer
extends AbstractBuiltInProducer
implements IStatsProducer,
BuiltInProducer {
    private String producerId;
    private MemoryStats stats;
    private List<IStats> statsList = new CopyOnWriteArrayList<IStats>();
    private RuntimeMemoryResolver resolver;
    public static final String FREE = "JavaRuntimeFree";
    public static final String MAX = "JavaRuntimeMax";
    public static final String TOTAL = "JavaRuntimeTotal";

    public BuiltInMemoryProducer(String aProducerId) {
        this.stats = new MemoryStats(aProducerId);
        this.statsList.add(this.stats);
        this.producerId = aProducerId;
        if (FREE.equals(aProducerId)) {
            this.resolver = new FreeMemoryResolver();
        }
        if (MAX.equals(aProducerId)) {
            this.resolver = new MaxMemoryResolver();
        }
        if (TOTAL.equals(aProducerId)) {
            this.resolver = new TotalMemoryResolver();
        }
        if (this.resolver == null) {
            throw new IllegalArgumentException("Illegal producerId, expected: JavaRuntimeFree, JavaRuntimeTotal or JavaRuntimeMax");
        }
        BuiltinUpdater.addTask(new TimerTask(){

            @Override
            public void run() {
                BuiltInMemoryProducer.this.readMemory();
            }
        });
    }

    @Override
    public String getCategory() {
        return "memory";
    }

    @Override
    public String getProducerId() {
        return this.producerId;
    }

    public List<IStats> getStats() {
        return this.statsList;
    }

    @Override
    public String getSubsystem() {
        return "builtin";
    }

    private void readMemory() {
        this.stats.updateMemoryValue(this.resolver.getMemoryValue());
    }

    @Override
    public String toString() {
        return super.toString() + " " + this.resolver.getClass().getSimpleName();
    }

    private static class TotalMemoryResolver
    implements RuntimeMemoryResolver {
        private TotalMemoryResolver() {
        }

        @Override
        public long getMemoryValue() {
            return Runtime.getRuntime().totalMemory();
        }
    }

    private static class MaxMemoryResolver
    implements RuntimeMemoryResolver {
        private MaxMemoryResolver() {
        }

        @Override
        public long getMemoryValue() {
            return Runtime.getRuntime().maxMemory();
        }
    }

    private static class FreeMemoryResolver
    implements RuntimeMemoryResolver {
        private FreeMemoryResolver() {
        }

        @Override
        public long getMemoryValue() {
            return Runtime.getRuntime().freeMemory();
        }
    }

    private static interface RuntimeMemoryResolver {
        public long getMemoryValue();
    }
}

