/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;

public final class IOUtils {
    private IOUtils() {
    }

    public static String getInputStreamAsString(InputStream is) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ReadableByteChannel rbch = Channels.newChannel(is);
        WritableByteChannel wbch = Channels.newChannel(baos);
        IOUtils.fastChannelCopy(rbch, wbch);
        rbch.close();
        wbch.close();
        return new String(baos.toByteArray());
    }

    public static void fastChannelCopy(InputStream src, OutputStream dest) throws IOException {
        ReadableByteChannel rbch = Channels.newChannel(src);
        WritableByteChannel wbch = Channels.newChannel(dest);
        IOUtils.fastChannelCopy(rbch, wbch);
        rbch.close();
        wbch.close();
    }

    public static void fastChannelCopy(ReadableByteChannel src, WritableByteChannel dest) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocateDirect(16384);
        while (src.read(buffer) != -1) {
            buffer.flip();
            dest.write(buffer);
            buffer.compact();
        }
        buffer.flip();
        while (buffer.hasRemaining()) {
            dest.write(buffer);
        }
    }
}

