/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.util;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.anotheria.moskito.core.config.MoskitoConfigurationHolder;
import net.anotheria.moskito.core.registry.IProducerRegistry;
import net.anotheria.moskito.core.registry.ProducerRegistryFactory;
import net.anotheria.moskito.core.util.BuiltInMemoryPoolProducer;
import net.anotheria.moskito.core.util.BuiltInMemoryPoolVirtualProducer;
import net.anotheria.moskito.core.util.BuiltInMemoryProducer;
import net.anotheria.moskito.core.util.BuiltInOSProducer;
import net.anotheria.moskito.core.util.BuiltInRuntimeProducer;
import net.anotheria.moskito.core.util.BuiltInThreadCountProducer;
import net.anotheria.moskito.core.util.BuiltInThreadStatesProducer;
import net.anotheria.moskito.core.util.MBeanProducerFactory;

public class StartBuiltInProducers {
    private static volatile boolean initialized = false;

    public static synchronized void startbuiltin() {
        if (initialized) {
            return;
        }
        initialized = true;
        StartBuiltInProducers.startJavaMemoryProducers();
        StartBuiltInProducers.startJavaThreadingProducers();
        StartBuiltInProducers.startOsProducers();
        StartBuiltInProducers.startMBeanProducers();
    }

    public static void restartbuiltin() {
        initialized = false;
        StartBuiltInProducers.startbuiltin();
    }

    private static void startJavaThreadingProducers() {
        if (!MoskitoConfigurationHolder.getConfiguration().getBuiltinProducersConfig().isJavaThreadingProducers()) {
            return;
        }
        new BuiltInThreadStatesProducer();
        new BuiltInThreadCountProducer();
    }

    private static void startOsProducers() {
        if (MoskitoConfigurationHolder.getConfiguration().getBuiltinProducersConfig().isOsProducer()) {
            new BuiltInOSProducer();
        }
        if (MoskitoConfigurationHolder.getConfiguration().getBuiltinProducersConfig().isRuntimeProducer()) {
            new BuiltInRuntimeProducer();
        }
    }

    private static void startJavaMemoryProducers() {
        IProducerRegistry registry = ProducerRegistryFactory.getProducerRegistryInstance();
        if (MoskitoConfigurationHolder.getConfiguration().getBuiltinProducersConfig().isJavaMemoryProducers()) {
            registry.registerProducer(new BuiltInMemoryProducer("JavaRuntimeFree"));
            registry.registerProducer(new BuiltInMemoryProducer("JavaRuntimeMax"));
            registry.registerProducer(new BuiltInMemoryProducer("JavaRuntimeTotal"));
        }
        if (MoskitoConfigurationHolder.getConfiguration().getBuiltinProducersConfig().isJavaMemoryPoolProducers()) {
            HashMap<MemoryType, ArrayList<BuiltInMemoryPoolProducer>> producers = new HashMap<MemoryType, ArrayList<BuiltInMemoryPoolProducer>>();
            List<MemoryPoolMXBean> pools = ManagementFactory.getMemoryPoolMXBeans();
            for (MemoryPoolMXBean memoryPoolMXBean : pools) {
                BuiltInMemoryPoolProducer p = new BuiltInMemoryPoolProducer(memoryPoolMXBean);
                registry.registerProducer(p);
                ArrayList<BuiltInMemoryPoolProducer> pp = (ArrayList<BuiltInMemoryPoolProducer>)producers.get((Object)memoryPoolMXBean.getType());
                if (pp == null) {
                    pp = new ArrayList<BuiltInMemoryPoolProducer>();
                    producers.put(memoryPoolMXBean.getType(), pp);
                }
                pp.add(p);
            }
            for (Map.Entry entry : producers.entrySet()) {
                BuiltInMemoryPoolVirtualProducer vp = new BuiltInMemoryPoolVirtualProducer((MemoryType)((Object)entry.getKey()), (List)entry.getValue());
                registry.registerProducer(vp);
            }
        }
    }

    private static void startMBeanProducers() {
        if (MoskitoConfigurationHolder.getConfiguration().getMbeanProducersConfig().isRegisterAutomatically()) {
            MBeanProducerFactory.buildProducers();
        }
    }
}

