/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.util.storage;

import net.anotheria.moskito.core.predefined.Constants;
import net.anotheria.moskito.core.producers.AbstractStats;
import net.anotheria.moskito.core.stats.Interval;
import net.anotheria.moskito.core.stats.StatValue;
import net.anotheria.moskito.core.stats.TimeUnit;
import net.anotheria.moskito.core.stats.impl.StatValueFactory;

public class StorageStats
extends AbstractStats {
    private StatValue gets;
    private StatValue missedGets;
    private StatValue puts;
    private StatValue overwritePuts;
    private StatValue removes;
    private StatValue noopRemoves;
    private StatValue size;
    private StatValue containsKeyCalls;
    private StatValue containsKeyHits;
    private StatValue containsValueCalls;
    private StatValue containsValueHits;
    private String name;

    public StorageStats() {
        this("unnamed", Constants.getDefaultIntervals());
    }

    public StorageStats(String name) {
        this(name, Constants.getDefaultIntervals());
    }

    public StorageStats(String aName, Interval[] selectedIntervals) {
        Long longPattern = 0L;
        this.name = aName;
        this.gets = StatValueFactory.createStatValue(longPattern, "gets", selectedIntervals);
        this.missedGets = StatValueFactory.createStatValue(longPattern, "missedGets", selectedIntervals);
        this.puts = StatValueFactory.createStatValue(longPattern, "puts", selectedIntervals);
        this.overwritePuts = StatValueFactory.createStatValue(longPattern, "overwritePuts", selectedIntervals);
        this.removes = StatValueFactory.createStatValue(longPattern, "removes", selectedIntervals);
        this.noopRemoves = StatValueFactory.createStatValue(longPattern, "noopRemoves", selectedIntervals);
        this.containsKeyCalls = StatValueFactory.createStatValue(longPattern, "containsKeyCalls", selectedIntervals);
        this.containsKeyHits = StatValueFactory.createStatValue(longPattern, "containsKeyHits", selectedIntervals);
        this.containsValueCalls = StatValueFactory.createStatValue(longPattern, "containsValueCalls", selectedIntervals);
        this.containsValueHits = StatValueFactory.createStatValue(longPattern, "containsValueHits", selectedIntervals);
        this.size = StatValueFactory.createStatValue(longPattern, "size", selectedIntervals);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String toStatsString(String intervalName, TimeUnit unit) {
        StringBuilder b = new StringBuilder();
        b.append(this.getName()).append(' ');
        b.append(" G: ").append(this.gets.getValueAsLong(intervalName));
        b.append(" mG: ").append(this.missedGets.getValueAsLong(intervalName));
        b.append(" mG R: ").append(this.getMissedGetRatio(intervalName));
        b.append(" hG R: ").append(this.getHitGetRatio(intervalName));
        b.append(" P: ").append(this.puts.getValueAsLong(intervalName));
        b.append(" oP: ").append(this.overwritePuts.getValueAsLong(intervalName));
        b.append(" oP R: ").append(this.getOverwritePutRatio(intervalName));
        b.append(" nP R: ").append(this.getNewPutRatio(intervalName));
        b.append(" RM: ").append(this.removes.getValueAsLong(intervalName));
        b.append(" noRM: ").append(this.noopRemoves.getValueAsLong(intervalName));
        b.append(" noRM R: ").append(this.getNoopRemoveRatio(intervalName));
        b.append(" PG R: ").append(this.getPutGetRatio(intervalName));
        b.append(" PRM R: ").append(this.getPutRemoveRatio(intervalName));
        b.append(" SZ: ").append(this.size.getValueAsLong(intervalName));
        b.append(" CKC: ").append(this.containsKeyCalls.getValueAsLong(intervalName));
        b.append(" CKH: ").append(this.containsKeyHits.getValueAsLong(intervalName));
        b.append(" CK HR: ").append(this.containsKeyHits.getValueAsLong(intervalName));
        b.append(" CVC: ").append(this.containsValueCalls.getValueAsLong(intervalName));
        b.append(" CVH: ").append(this.getContainsKeyHitRatio(intervalName));
        b.append(" CV HR: ").append(this.getContainsValueHitRatio(intervalName));
        return b.toString();
    }

    public double getNoopRemoveRatio(String intervalName) {
        return this.noopRemoves.getValueAsDouble(intervalName) / this.removes.getValueAsDouble(intervalName);
    }

    public double getOverwritePutRatio(String intervalName) {
        return this.overwritePuts.getValueAsDouble(intervalName) / this.puts.getValueAsDouble(intervalName);
    }

    public double getNewPutRatio(String intervalName) {
        long putsAsLong = this.puts.getValueAsLong(intervalName);
        return (double)(putsAsLong - this.overwritePuts.getValueAsLong(intervalName)) / (double)putsAsLong;
    }

    public double getMissedGetRatio(String intervalName) {
        return this.missedGets.getValueAsDouble(intervalName) / this.gets.getValueAsDouble(intervalName);
    }

    public double getHitGetRatio(String intervalName) {
        long getAsLong = this.gets.getValueAsLong(intervalName);
        return (double)(getAsLong - this.missedGets.getValueAsLong(intervalName)) / (double)getAsLong;
    }

    public double getContainsKeyHitRatio(String intervalName) {
        return this.containsKeyHits.getValueAsDouble(intervalName) / (double)this.containsKeyCalls.getValueAsLong(intervalName);
    }

    public double getContainsValueHitRatio(String intervalName) {
        return this.containsValueHits.getValueAsDouble(intervalName) / (double)this.containsValueCalls.getValueAsLong(intervalName);
    }

    public double getPutGetRatio(String intervalName) {
        return this.puts.getValueAsDouble(intervalName) / (double)this.gets.getValueAsLong(intervalName);
    }

    public double getPutRemoveRatio(String intervalName) {
        return this.puts.getValueAsDouble(intervalName) / (double)this.removes.getValueAsLong(intervalName);
    }

    public void addGet() {
        this.gets.increase();
    }

    public void addMissedGet() {
        this.missedGets.increase();
    }

    public void addPut() {
        this.puts.increase();
    }

    public void addOverwritePut() {
        this.overwritePuts.increase();
    }

    public void increaseSize() {
        this.size.increase();
    }

    public void decreaseSize() {
        this.size.decrease();
    }

    public void setSize(int aSize) {
        this.size.setValueAsInt(aSize);
    }

    public void addContainsKeyHit() {
        this.containsKeyCalls.increase();
        this.containsKeyHits.increase();
    }

    public void addContainsKeyMiss() {
        this.containsKeyCalls.increase();
    }

    public void addContainsValueHit() {
        this.containsValueCalls.increase();
        this.containsValueHits.increase();
    }

    public void addContainsValueMiss() {
        this.containsValueCalls.increase();
    }

    public void addRemove() {
        this.removes.increase();
    }

    public void addNoopRemove() {
        this.noopRemoves.increase();
    }

    public long getContainsKeyCalls(String intervalName) {
        return this.containsKeyCalls.getValueAsLong(intervalName);
    }

    public long getContainsKeyHits(String intervalName) {
        return this.containsKeyHits.getValueAsLong(intervalName);
    }

    public long getContainsValueCalls(String intervalName) {
        return this.containsValueCalls.getValueAsLong(intervalName);
    }

    public long getContainsValueHits(String intervalName) {
        return this.containsValueHits.getValueAsLong(intervalName);
    }

    public long getGets(String intervalName) {
        return this.gets.getValueAsLong(intervalName);
    }

    public long getMissedGets(String intervalName) {
        return this.missedGets.getValueAsLong(intervalName);
    }

    public long getNoopRemoves(String intervalName) {
        return this.noopRemoves.getValueAsLong(intervalName);
    }

    public long getOverwritePuts(String intervalName) {
        return this.overwritePuts.getValueAsLong(intervalName);
    }

    public long getPuts(String intervalName) {
        return this.puts.getValueAsLong(intervalName);
    }

    public long getRemoves(String intervalName) {
        return this.removes.getValueAsLong(intervalName);
    }

    public long getSize(String intervalName) {
        return this.size.getValueAsLong(intervalName);
    }
}

