/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.config.dashboards;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import java.util.Arrays;
import org.configureme.annotations.Configure;
import org.configureme.annotations.ConfigureMe;

@ConfigureMe
@SuppressFBWarnings(value={"EI_EXPOSE_REP2", "EI_EXPOSE_REP"}, justification="This is the way configureme works, it provides beans for access")
public class ChartConfig
implements Serializable {
    private static final long serialVersionUID = 8677290973596785948L;
    @Configure
    private String caption;
    @Configure
    private String[] accumulators;

    public String[] getAccumulators() {
        return this.accumulators;
    }

    public void setAccumulators(String[] accumulators) {
        this.accumulators = accumulators;
        if (this.accumulators != null) {
            Arrays.sort(this.accumulators);
        }
    }

    public String getCaption() {
        return this.caption;
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }

    public String toString() {
        return "ChartConfig{accumulators=" + Arrays.toString(this.accumulators) + ", caption='" + this.caption + '\'' + '}';
    }

    public String buildCaption() {
        StringBuilder captionBuilder = new StringBuilder();
        int numAccumulators = this.accumulators.length;
        for (int i = 0; i < numAccumulators; ++i) {
            String accumulator = this.accumulators[i];
            captionBuilder.append(accumulator);
            if (i == numAccumulators - 1) continue;
            captionBuilder.append(' ');
        }
        return captionBuilder.toString();
    }
}

