/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.config.thresholds;

import java.io.Serializable;
import java.util.Arrays;
import net.anotheria.moskito.core.config.thresholds.GuardConfig;
import net.anotheria.moskito.core.stats.TimeUnit;
import org.configureme.annotations.Configure;
import org.configureme.annotations.ConfigureMe;

@ConfigureMe(allfields=true)
public class ThresholdConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Configure
    private String name;
    @Configure
    private String producerName;
    @Configure
    private String statName;
    @Configure
    private String valueName;
    @Configure
    private String intervalName = "5m";
    @Configure
    private String timeUnit = TimeUnit.MILLISECONDS.name();
    @Configure
    private GuardConfig[] guards;

    public GuardConfig[] getGuards() {
        if (this.guards == null || this.guards.length == 0) {
            return new GuardConfig[0];
        }
        GuardConfig[] ret = new GuardConfig[this.guards.length];
        System.arraycopy(this.guards, 0, ret, 0, this.guards.length);
        return ret;
    }

    public void setGuards(GuardConfig[] guards) {
        if (guards == null || guards.length == 0) {
            return;
        }
        this.guards = new GuardConfig[guards.length];
        System.arraycopy(guards, 0, this.guards, 0, guards.length);
    }

    public String toString() {
        return "ThresholdConfig{name='" + this.name + '\'' + ", producerName='" + this.producerName + '\'' + ", statName='" + this.statName + '\'' + ", valueName='" + this.valueName + '\'' + ", intervalName='" + this.intervalName + '\'' + ", timeUnit='" + this.timeUnit + '\'' + ", guards=" + (this.guards == null ? null : Arrays.toString(this.guards)) + '}';
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getProducerName() {
        return this.producerName;
    }

    public void setProducerName(String producerName) {
        this.producerName = producerName;
    }

    public String getStatName() {
        return this.statName;
    }

    public void setStatName(String statName) {
        this.statName = statName;
    }

    public String getValueName() {
        return this.valueName;
    }

    public void setValueName(String valueName) {
        this.valueName = valueName;
    }

    public String getIntervalName() {
        return this.intervalName;
    }

    public void setIntervalName(String intervalName) {
        this.intervalName = intervalName;
    }

    public String getTimeUnit() {
        return this.timeUnit;
    }

    public void setTimeUnit(String timeUnit) {
        this.timeUnit = timeUnit;
    }
}

