/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.decorators.counter;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.anotheria.moskito.core.counter.GenericCounterStats;
import net.anotheria.moskito.core.decorators.AbstractDecorator;
import net.anotheria.moskito.core.decorators.value.LongValueAO;
import net.anotheria.moskito.core.decorators.value.StatValueAO;
import net.anotheria.moskito.core.stats.TimeUnit;

public abstract class GenericCounterDecorator
extends AbstractDecorator<GenericCounterStats> {
    private final Set<String> valueNames;
    private String[] captions;

    public GenericCounterDecorator(GenericCounterStats patternObject, String[] captions, String[] shortExplanations, String[] explanations) {
        super(patternObject.describeForWebUI(), captions, shortExplanations, explanations);
        this.valueNames = patternObject.getPossibleNames();
        this.captions = captions;
    }

    @Override
    public List<StatValueAO> getValues(GenericCounterStats stats, String interval, TimeUnit unit) {
        ArrayList<StatValueAO> ret = new ArrayList<StatValueAO>(this.valueNames.size());
        int i = 0;
        for (String name : this.valueNames) {
            ret.add(new LongValueAO(this.captions[i++], stats.get(name, interval)));
        }
        return ret;
    }
}

