/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.decorators.predefined;

import java.util.ArrayList;
import java.util.List;
import net.anotheria.moskito.core.decorators.AbstractDecorator;
import net.anotheria.moskito.core.decorators.value.LongValueAO;
import net.anotheria.moskito.core.decorators.value.StatValueAO;
import net.anotheria.moskito.core.predefined.ThreadStateStats;
import net.anotheria.moskito.core.stats.TimeUnit;

public class ThreadStatesDecorator
extends AbstractDecorator<ThreadStateStats> {
    private static final String[] CAPTIONS = new String[]{"Min", "Current", "Max"};
    private static final String[] SHORT_EXPLANATIONS = new String[]{"Min number of threads in this state", "Number of currently running threads in this state", "Max number of threads in this state"};
    private static final String[] EXPLANATIONS = new String[]{"Min number of threads in this state", "Number of currently running threads in this state", "Max number of threads in this state"};

    public ThreadStatesDecorator() {
        super("ThreadStates", CAPTIONS, SHORT_EXPLANATIONS, EXPLANATIONS);
    }

    @Override
    public List<StatValueAO> getValues(ThreadStateStats statsObject, String interval, TimeUnit unit) {
        ArrayList<StatValueAO> ret = new ArrayList<StatValueAO>(CAPTIONS.length);
        int i = 0;
        ret.add(new LongValueAO(CAPTIONS[i++], statsObject.getMin(interval)));
        ret.add(new LongValueAO(CAPTIONS[i++], statsObject.getCurrent(interval)));
        ret.add(new LongValueAO(CAPTIONS[i++], statsObject.getMax(interval)));
        return ret;
    }
}

