/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.predefined;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.anotheria.moskito.core.predefined.Constants;
import net.anotheria.moskito.core.producers.AbstractStats;
import net.anotheria.moskito.core.stats.Interval;
import net.anotheria.moskito.core.stats.StatValue;
import net.anotheria.moskito.core.stats.TimeUnit;
import net.anotheria.moskito.core.stats.impl.StatValueFactory;

public class RuntimeStats
extends AbstractStats {
    private static final List<String> VALUE_NAMES = Collections.unmodifiableList(Arrays.asList("Process", "Starttime", "Uptime"));
    private StatValue processName;
    private StatValue startTime;
    private StatValue uptime;

    public RuntimeStats() {
        this("Runtime", Constants.getDefaultIntervals());
    }

    public RuntimeStats(String aName) {
        this(aName, Constants.getDefaultIntervals());
    }

    public RuntimeStats(String aName, Interval[] selectedIntervals) {
        super(aName);
        this.processName = StatValueFactory.createStatValue("", "processName", selectedIntervals);
        this.startTime = StatValueFactory.createStatValue(0L, "startTime", selectedIntervals);
        this.uptime = StatValueFactory.createStatValue(0L, "uptime", selectedIntervals);
        this.addStatValues(this.processName, this.startTime, this.uptime);
    }

    public void update(String aName, long aStartTime, long anUptime) {
        this.processName.setValueAsString(aName);
        this.startTime.setValueAsLong(aStartTime);
        this.uptime.setValueAsLong(anUptime);
    }

    @Override
    public String toStatsString(String intervalName, TimeUnit unit) {
        StringBuilder ret = new StringBuilder();
        ret.append(this.getName()).append(' ');
        ret.append(" process: ").append(this.processName.getValueAsString(intervalName));
        ret.append(" starttime: ").append(this.startTime.getValueAsLong(intervalName));
        ret.append(" uptime: ").append(this.uptime.getValueAsInt(intervalName));
        return ret.toString();
    }

    @Override
    public String getValueByNameAsString(String valueName, String intervalName, TimeUnit timeUnit) {
        if (valueName == null) {
            throw new AssertionError((Object)"Value name can't be null");
        }
        if ((valueName = valueName.toLowerCase()).equals("process") || valueName.equals("name") || valueName.equals("processname")) {
            return this.processName.getValueAsString(intervalName);
        }
        if (valueName.equals("starttime")) {
            return String.valueOf(this.getStartTime(intervalName));
        }
        if (valueName.equals("uptime")) {
            return String.valueOf(this.getUptime(intervalName));
        }
        return super.getValueByNameAsString(valueName, intervalName, timeUnit);
    }

    public String getProcessName(String intervalName) {
        return this.processName.getValueAsString(intervalName);
    }

    public long getStartTime(String intervalName) {
        return this.startTime.getValueAsLong(intervalName);
    }

    public long getUptime(String intervalName) {
        return this.uptime.getValueAsLong(intervalName);
    }

    @Override
    public List<String> getAvailableValueNames() {
        return VALUE_NAMES;
    }
}

