/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.predefined;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.anotheria.moskito.core.predefined.Constants;
import net.anotheria.moskito.core.producers.AbstractStats;
import net.anotheria.moskito.core.stats.Interval;
import net.anotheria.moskito.core.stats.StatValue;
import net.anotheria.moskito.core.stats.TimeUnit;
import net.anotheria.moskito.core.stats.impl.StatValueFactory;

public class ThreadStateStats
extends AbstractStats {
    private static final List<String> VALUE_NAMES = Collections.unmodifiableList(Arrays.asList("CUR", "MIN", "MAX"));
    private StatValue current;
    private StatValue min;
    private StatValue max;

    public ThreadStateStats() {
        this("unnamed", Constants.getDefaultIntervals());
    }

    public ThreadStateStats(String aName) {
        this(aName, Constants.getDefaultIntervals());
    }

    public ThreadStateStats(String aName, Interval[] selectedIntervals) {
        super(aName);
        this.current = StatValueFactory.createStatValue(0L, "current", selectedIntervals);
        this.min = StatValueFactory.createStatValue(0L, "min", selectedIntervals);
        this.min.setDefaultValueAsLong(Long.MAX_VALUE);
        this.min.reset();
        this.max = StatValueFactory.createStatValue(0L, "max", selectedIntervals);
        this.max.setDefaultValueAsLong(Long.MIN_VALUE);
        this.max.reset();
        this.addStatValues(this.current, this.min, this.max);
    }

    @Override
    public String toStatsString(String intervalName, TimeUnit timeUnit) {
        StringBuilder b = new StringBuilder();
        b.append(this.getName()).append(' ');
        b.append(" CUR: ").append(this.current.getValueAsLong(intervalName));
        b.append(" MIN: ").append(this.min.getValueAsLong(intervalName));
        b.append(" MAX: ").append(this.max.getValueAsLong(intervalName));
        return b.toString();
    }

    public void updateCurrentValue(long value) {
        this.current.setValueAsLong(value);
        this.min.setValueIfLesserThanCurrentAsLong(value);
        this.max.setValueIfGreaterThanCurrentAsLong(value);
    }

    public long getCurrent(String intervalName) {
        return this.current.getValueAsLong(intervalName);
    }

    public long getMin(String intervalName) {
        return this.min.getValueAsLong(intervalName);
    }

    public long getMax(String intervalName) {
        return this.max.getValueAsLong(intervalName);
    }

    @Override
    public String getValueByNameAsString(String valueName, String intervalName, TimeUnit timeUnit) {
        if (valueName == null || valueName.isEmpty()) {
            throw new AssertionError((Object)"Value name can not be empty");
        }
        if ((valueName = valueName.toLowerCase()).equals("cur") || valueName.equals("current")) {
            return String.valueOf(this.getCurrent(intervalName));
        }
        if (valueName.equals("min")) {
            return String.valueOf(this.getMin(intervalName));
        }
        if (valueName.equals("max")) {
            return String.valueOf(this.getMax(intervalName));
        }
        return super.getValueByNameAsString(valueName, intervalName, timeUnit);
    }

    @Override
    public List<String> getAvailableValueNames() {
        return VALUE_NAMES;
    }
}

