/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.threshold;

import java.util.ArrayList;
import java.util.List;
import net.anotheria.moskito.core.config.thresholds.ThresholdConfig;
import net.anotheria.moskito.core.helper.AbstractTieable;
import net.anotheria.moskito.core.helper.Tieable;
import net.anotheria.moskito.core.producers.IStats;
import net.anotheria.moskito.core.threshold.ThresholdConditionGuard;
import net.anotheria.moskito.core.threshold.ThresholdDefinition;
import net.anotheria.moskito.core.threshold.ThresholdMBean;
import net.anotheria.moskito.core.threshold.ThresholdStatus;
import net.anotheria.moskito.core.threshold.alerts.AlertDispatcher;
import net.anotheria.moskito.core.threshold.alerts.ThresholdAlert;
import net.anotheria.moskito.core.threshold.guard.GuardedDirection;
import net.anotheria.moskito.core.threshold.guard.LongBarrierPassGuard;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Threshold
extends AbstractTieable<ThresholdDefinition>
implements Tieable,
ThresholdMBean {
    private static Logger log = LoggerFactory.getLogger(Threshold.class);
    private ThresholdStatus status;
    private List<ThresholdConditionGuard> guards;
    private IStats stats;
    private String lastValue = "none yet";
    private long statusChangeTimestamp;
    private ThresholdStatus previousStatus = ThresholdStatus.OFF;
    private int flipCount = 0;

    public Threshold(ThresholdDefinition aDefinition) {
        super(aDefinition);
        this.status = ThresholdStatus.OFF;
        this.guards = new ArrayList<ThresholdConditionGuard>();
    }

    @Override
    public void tieToStats(IStats aStatsObject) {
        this.stats = aStatsObject;
    }

    public void addGuard(ThresholdConditionGuard guard) {
        this.guards.add(guard);
    }

    public void addLongGuardLineDownUp(long green, long yellow, long orange, long red, long purple) {
        this.addLongGuardLine(green, yellow, orange, red, purple, GuardedDirection.DOWN, GuardedDirection.UP);
    }

    public void addLongGuardLineUpDown(long green, long yellow, long orange, long red, long purple) {
        this.addLongGuardLine(green, yellow, orange, red, purple, GuardedDirection.UP, GuardedDirection.DOWN);
    }

    private void addLongGuardLine(long green, long yellow, long orange, long red, long purple, GuardedDirection first, GuardedDirection other) {
        this.addGuard(new LongBarrierPassGuard(ThresholdStatus.GREEN, green, first));
        this.addGuard(new LongBarrierPassGuard(ThresholdStatus.YELLOW, yellow, other));
        this.addGuard(new LongBarrierPassGuard(ThresholdStatus.ORANGE, orange, other));
        this.addGuard(new LongBarrierPassGuard(ThresholdStatus.RED, red, other));
        this.addGuard(new LongBarrierPassGuard(ThresholdStatus.PURPLE, purple, other));
    }

    public List<ThresholdConditionGuard> getGuards() {
        ArrayList<ThresholdConditionGuard> ret = new ArrayList<ThresholdConditionGuard>(this.guards.size());
        ret.addAll(this.guards);
        return ret;
    }

    public ThresholdStatus getStatus() {
        return this.status;
    }

    @Override
    public String getStatusString() {
        return this.getStatus().name();
    }

    public IStats getStats() {
        return this.stats;
    }

    public String getLastValue() {
        return this.lastValue;
    }

    @Override
    public void update() {
        if (!this.isActivated()) {
            return;
        }
        String previousValue = this.lastValue;
        this.lastValue = this.stats.getValueByNameAsString(((ThresholdDefinition)this.getDefinition()).getValueName(), ((ThresholdDefinition)this.getDefinition()).getIntervalName(), ((ThresholdDefinition)this.getDefinition()).getTimeUnit());
        ThresholdStatus futureStatus = this.status == ThresholdStatus.OFF ? ThresholdStatus.OFF : ThresholdStatus.GREEN;
        for (ThresholdConditionGuard guard : this.guards) {
            try {
                ThresholdStatus newStatus = guard.getNewStatusOnUpdate(previousValue, this.lastValue, this.status, this);
                if (!newStatus.overrules(futureStatus)) continue;
                futureStatus = newStatus;
            }
            catch (Exception e) {
                log.warn("Error in ThresholdConditionGuard: " + guard + " in getNewStatusOnUpdate(" + previousValue + ", " + this.lastValue + ", " + (Object)((Object)this.status) + ", " + this, (Throwable)e);
            }
        }
        if (this.status != futureStatus) {
            ++this.flipCount;
            this.previousStatus = this.status;
            this.statusChangeTimestamp = System.currentTimeMillis();
            AlertDispatcher.INSTANCE.dispatchAlert(new ThresholdAlert(this, this.status, futureStatus, previousValue, this.lastValue, this.flipCount));
        }
        this.status = futureStatus;
    }

    @Override
    public boolean isActivated() {
        return this.stats != null;
    }

    public String toString() {
        return this.getName() + ' ' + (Object)((Object)this.getStatus()) + " Def: " + this.getDefinition() + " LastValue: " + this.getLastValue() + ", Guards: " + this.guards + " active: " + this.isActivated() + ", Stats: " + this.getStats();
    }

    public long getStatusChangeTimestamp() {
        return this.statusChangeTimestamp;
    }

    public void setStatusChangeTimestamp(long statusChangeTimestamp) {
        this.statusChangeTimestamp = statusChangeTimestamp;
    }

    public int getFlipCount() {
        return this.flipCount;
    }

    public ThresholdConfig toConfigObject() {
        ThresholdConfig ret = new ThresholdConfig();
        ret.setIntervalName(((ThresholdDefinition)this.getDefinition()).getIntervalName());
        ret.setName(((ThresholdDefinition)this.getDefinition()).getName());
        ret.setProducerName(((ThresholdDefinition)this.getDefinition()).getProducerName());
        ret.setStatName(((ThresholdDefinition)this.getDefinition()).getStatName());
        ret.setValueName(((ThresholdDefinition)this.getDefinition()).getValueName());
        ret.setTimeUnit(((ThresholdDefinition)this.getDefinition()).getTimeUnit().name());
        return ret;
    }

    public ThresholdStatus getPreviousStatus() {
        return this.previousStatus;
    }
}

