/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.util;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.List;
import java.util.TimerTask;
import java.util.concurrent.CopyOnWriteArrayList;
import net.anotheria.moskito.core.predefined.ThreadCountStats;
import net.anotheria.moskito.core.producers.IStatsProducer;
import net.anotheria.moskito.core.registry.IProducerRegistry;
import net.anotheria.moskito.core.registry.ProducerRegistryFactory;
import net.anotheria.moskito.core.util.AbstractBuiltInProducer;
import net.anotheria.moskito.core.util.BuiltInProducer;
import net.anotheria.moskito.core.util.BuiltinUpdater;

public class BuiltInThreadCountProducer
extends AbstractBuiltInProducer<ThreadCountStats>
implements IStatsProducer<ThreadCountStats>,
BuiltInProducer {
    private List<ThreadCountStats> statsList;
    private ThreadCountStats stats = new ThreadCountStats();
    private ThreadMXBean threadMxBean;

    BuiltInThreadCountProducer() {
        this.statsList = new CopyOnWriteArrayList<ThreadCountStats>();
        this.statsList.add(this.stats);
        this.threadMxBean = ManagementFactory.getThreadMXBean();
        IProducerRegistry reg = ProducerRegistryFactory.getProducerRegistryInstance();
        reg.registerProducer(this);
        BuiltinUpdater.addTask(new TimerTask(){

            @Override
            public void run() {
                BuiltInThreadCountProducer.this.readThreads();
            }
        });
    }

    private void readThreads() {
        this.stats.update(this.threadMxBean.getTotalStartedThreadCount(), this.threadMxBean.getDaemonThreadCount(), this.threadMxBean.getThreadCount());
    }

    @Override
    public String getCategory() {
        return "threads";
    }

    @Override
    public String getProducerId() {
        return "ThreadCount";
    }

    @Override
    public List<ThreadCountStats> getStats() {
        return this.statsList;
    }
}

