/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.util.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public final class AnnotationUtils {
    private AnnotationUtils() {
    }

    public static <A extends Annotation> A findAnnotation(AnnotatedElement annotatedElement, Class<A> annotationClass) {
        Objects.requireNonNull(annotatedElement);
        Objects.requireNonNull(annotationClass);
        A result = annotatedElement.getAnnotation(annotationClass);
        if (result != null) {
            return result;
        }
        return AnnotationUtils.findAnnotationInAnnotations(annotatedElement, annotationClass);
    }

    private static <A extends Annotation> A findAnnotationInAnnotations(AnnotatedElement annotatedElement, Class<A> annotationClass) {
        Annotation[] allAnnotations;
        for (Annotation annotation : allAnnotations = annotatedElement.getAnnotations()) {
            A result = AnnotationUtils.findAnnotation(annotation, annotationClass);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static <A extends Annotation> A findAnnotation(Annotation annotation, Class<A> annotationClass) {
        HashSet<Class<? extends Annotation>> visitedAnnotations = new HashSet<Class<? extends Annotation>>();
        return AnnotationUtils.findAnnotation(annotation, annotationClass, visitedAnnotations);
    }

    private static <A extends Annotation> A findAnnotation(Annotation currentAnnotation, Class<A> annotationClass, Set<Class<? extends Annotation>> visitedAnnotations) {
        Annotation[] allAnnotations;
        Class<? extends Annotation> currentAnnotationType = currentAnnotation.annotationType();
        visitedAnnotations.add(currentAnnotationType);
        A result = currentAnnotationType.getAnnotation(annotationClass);
        if (result != null) {
            return result;
        }
        for (Annotation annotation : allAnnotations = currentAnnotationType.getAnnotations()) {
            Class<? extends Annotation> annotationType = annotation.annotationType();
            if (visitedAnnotations.contains(annotationType) || (result = AnnotationUtils.findAnnotation(annotation, annotationClass, visitedAnnotations)) == null) continue;
            return result;
        }
        return null;
    }
}

