/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.web.filters;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.anotheria.moskito.core.dynamic.EntryCountLimitedOnDemandStatsProducer;
import net.anotheria.moskito.core.dynamic.IOnDemandStatsFactory;
import net.anotheria.moskito.core.dynamic.OnDemandStatsProducer;
import net.anotheria.moskito.core.dynamic.OnDemandStatsProducerException;
import net.anotheria.moskito.core.predefined.PageInBrowserStats;
import net.anotheria.moskito.core.predefined.PageInBrowserStatsFactory;
import net.anotheria.moskito.core.producers.IStatsProducer;
import net.anotheria.moskito.core.registry.ProducerRegistryFactory;
import net.anotheria.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSTalkBackFilter
implements Filter {
    public static final String INIT_PARAM_LIMIT = "limit";
    private static final String URL = "url";
    private static final String DOM_LOAD_TIME = "domLoadTime";
    private static final String WINDOW_LOAD_TIME = "windowLoadTime";
    private static final String PRODUCER_ID = "producerId";
    private static final String CATEGORY = "category";
    private static final String SUBSYSTEM = "subsystem";
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private int limit = -1;

    public void init(FilterConfig filterConfig) throws ServletException {
        String pLimit = filterConfig.getInitParameter(INIT_PARAM_LIMIT);
        if (pLimit != null) {
            try {
                this.limit = Integer.parseInt(pLimit);
            }
            catch (NumberFormatException ignored) {
                this.log.warn("couldn't parse limit \"" + pLimit + "\", assume -1 aka no limit.");
            }
        }
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        String subsystem;
        String category;
        if (!(servletRequest instanceof HttpServletRequest) || !(servletResponse instanceof HttpServletResponse)) {
            return;
        }
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        String producerId = this.getValueOrDefault(request, PRODUCER_ID, this.getDefaultProducerId());
        OnDemandStatsProducer<PageInBrowserStats> producer = this.getProducer(producerId, category = this.getValueOrDefault(request, CATEGORY, this.getDefaultCategory()), subsystem = this.getValueOrDefault(request, SUBSYSTEM, this.getDefaultSubsystem()));
        if (producer == null) {
            return;
        }
        String urlPath = request.getParameter(URL);
        if (StringUtils.isEmpty((String)urlPath)) {
            return;
        }
        String domLoadTime = request.getParameter(DOM_LOAD_TIME);
        String windowLoadTime = request.getParameter(WINDOW_LOAD_TIME);
        try {
            PageInBrowserStats stats = (PageInBrowserStats)producer.getStats(urlPath);
            if (this.isLoadTimeValid(domLoadTime) && this.isLoadTimeValid(windowLoadTime)) {
                stats.addLoadTime(Long.valueOf(domLoadTime).longValue(), Long.valueOf(windowLoadTime).longValue());
                PageInBrowserStats cumulated = (PageInBrowserStats)producer.getDefaultStats();
                cumulated.addLoadTime(Long.valueOf(domLoadTime).longValue(), Long.valueOf(windowLoadTime).longValue());
            }
            this.writeNoContentResponse(response);
        }
        catch (OnDemandStatsProducerException e) {
            this.log.info("Couldn't get stats for : " + urlPath + ", probably limit reached");
        }
    }

    private String getValueOrDefault(HttpServletRequest req, String paramName, String defaultValue) {
        String value = req.getParameter(paramName);
        return StringUtils.isEmpty((String)value) ? defaultValue : value;
    }

    private boolean isLoadTimeValid(String loadTimeParam) {
        return !StringUtils.isEmpty((String)loadTimeParam) && this.isLong(loadTimeParam) && Long.valueOf(loadTimeParam) > 0L;
    }

    private OnDemandStatsProducer<PageInBrowserStats> getProducer(String producerId, String category, String subsystem) {
        IStatsProducer statsProducer = ProducerRegistryFactory.getProducerRegistryInstance().getProducer(producerId);
        if (statsProducer == null) {
            return this.createProducer(producerId, category, subsystem);
        }
        if (statsProducer instanceof OnDemandStatsProducer && ((OnDemandStatsProducer)OnDemandStatsProducer.class.cast(statsProducer)).getDefaultStats() instanceof PageInBrowserStats) {
            return (OnDemandStatsProducer)statsProducer;
        }
        IStatsProducer defaultStatsProducer = ProducerRegistryFactory.getProducerRegistryInstance().getProducer(this.getDefaultProducerId());
        if (defaultStatsProducer == null) {
            return this.createProducer(this.getDefaultProducerId(), category, subsystem);
        }
        if (statsProducer instanceof OnDemandStatsProducer && ((OnDemandStatsProducer)OnDemandStatsProducer.class.cast(statsProducer)).getDefaultStats() instanceof PageInBrowserStats) {
            return (OnDemandStatsProducer)defaultStatsProducer;
        }
        this.log.warn("Can't create OnDemandStatsProducer<BrowserStats> producer with passed id: [" + producerId + "] and default id: [" + this.getDefaultProducerId() + "].");
        return null;
    }

    private OnDemandStatsProducer<PageInBrowserStats> createProducer(String producerId, String category, String subsystem) {
        OnDemandStatsProducer producer = this.limit == -1 ? new OnDemandStatsProducer(producerId, category, subsystem, (IOnDemandStatsFactory)new PageInBrowserStatsFactory()) : new EntryCountLimitedOnDemandStatsProducer(producerId, category, subsystem, (IOnDemandStatsFactory)new PageInBrowserStatsFactory(), this.limit);
        ProducerRegistryFactory.getProducerRegistryInstance().registerProducer((IStatsProducer)producer);
        return producer;
    }

    private void writeNoContentResponse(HttpServletResponse response) throws IOException {
        response.setStatus(204);
        response.setContentType("image/gif");
        PrintWriter out = response.getWriter();
        out.flush();
    }

    public void destroy() {
    }

    public String getDefaultProducerId() {
        return this.getClass().getSimpleName();
    }

    public String getDefaultCategory() {
        return "default";
    }

    public String getDefaultSubsystem() {
        return "default";
    }

    private boolean isLong(String str) {
        try {
            Long.valueOf(str);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }
}

