/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.web.filters.caseextractor;

import javax.servlet.http.HttpServletRequest;
import net.anotheria.moskito.web.filters.caseextractor.AbstractFilterCaseExtractor;

public class RefererCaseExtractor
extends AbstractFilterCaseExtractor {
    public static final String HTTP_PROTOCOL = "http://";
    public static final String HTTPS_PROTOCOL = "https://";
    public static final int URI_LIMIT = 80;

    @Override
    public String extractCaseName(HttpServletRequest r) {
        String refererServerName;
        String currentServerName;
        String referer = r.getHeader("referer");
        if (referer == null || referer.length() == 0) {
            return null;
        }
        if (referer.startsWith(HTTP_PROTOCOL)) {
            referer = referer.substring(HTTP_PROTOCOL.length());
        }
        if (referer.startsWith(HTTPS_PROTOCOL)) {
            referer = referer.substring(HTTPS_PROTOCOL.length());
        }
        if ((currentServerName = r.getServerName()).equals(refererServerName = RefererCaseExtractor.extractServerName(referer))) {
            return "_this_server_";
        }
        if (referer.length() > 80) {
            referer = referer.substring(0, 77) + "...";
        }
        return referer;
    }

    private static String extractServerName(String referer) {
        int end = referer.indexOf(58);
        if (end == -1) {
            end = referer.indexOf(47);
        }
        if (end == -1) {
            return null;
        }
        return referer.substring(0, end);
    }
}

