/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.web.session;

import java.net.InetAddress;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import net.anotheria.moskito.core.dynamic.IOnDemandStatsFactory;
import net.anotheria.moskito.core.dynamic.OnDemandStatsProducer;
import net.anotheria.moskito.core.dynamic.OnDemandStatsProducerException;
import net.anotheria.moskito.core.registry.ProducerRegistryFactory;
import net.anotheria.moskito.core.util.session.SessionCountFactory;
import net.anotheria.moskito.core.util.session.SessionCountStats;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionByTldListener
implements HttpSessionListener,
ServletRequestListener {
    private static OnDemandStatsProducer<SessionCountStats> onDemandProducer;
    private static Logger log;
    public static final String ATT_NAME = "_MoSKito_SessionByTldFilter_TLD";

    public void sessionCreated(HttpSessionEvent se) {
    }

    public void sessionDestroyed(HttpSessionEvent se) {
        SessionByTldListener.countDestroyedSession((String)se.getSession().getAttribute(ATT_NAME));
    }

    public void requestDestroyed(ServletRequestEvent sre) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestInitialized(ServletRequestEvent sre) {
        String hostName;
        if (!(sre.getServletRequest() instanceof HttpServletRequest)) {
            return;
        }
        HttpServletRequest req = (HttpServletRequest)sre.getServletRequest();
        if (req.getSession(false) == null) {
            return;
        }
        HttpSession session = req.getSession();
        if (session.getAttribute(ATT_NAME) != null) {
            return;
        }
        String ip = req.getRemoteAddr();
        HttpSession httpSession = session;
        synchronized (httpSession) {
            if (session.getAttribute(ATT_NAME) != null) {
                return;
            }
            session.setAttribute(ATT_NAME, (Object)ip);
        }
        try {
            hostName = InetAddress.getByName(ip).getHostName();
            int indexOfTld = hostName.lastIndexOf(46);
            if (indexOfTld != -1) {
                hostName = hostName.substring(indexOfTld + 1);
            }
            if (hostName.length() > 20) {
                hostName = hostName.substring(0, 20);
            }
            if (Character.isDigit(hostName.charAt(hostName.length() - 1))) {
                hostName = "-unresolved-";
            }
        }
        catch (Exception e) {
            hostName = "ERROR";
        }
        session.setAttribute(ATT_NAME, (Object)hostName);
        SessionByTldListener.countCreatedSession(hostName);
    }

    private static void countCreatedSession(String tld) {
        ((SessionCountStats)onDemandProducer.getDefaultStats()).notifySessionCreated();
        try {
            ((SessionCountStats)onDemandProducer.getStats(tld)).notifySessionCreated();
        }
        catch (OnDemandStatsProducerException e) {
            log.warn("sessionCreated(" + tld + "), e");
        }
    }

    private static void countDestroyedSession(String tld) {
        if (tld == null) {
            return;
        }
        ((SessionCountStats)onDemandProducer.getDefaultStats()).notifySessionDestroyed();
        try {
            ((SessionCountStats)onDemandProducer.getStats(tld)).notifySessionDestroyed();
        }
        catch (OnDemandStatsProducerException e) {
            log.warn("sessionCreated(" + tld + "), e");
        }
    }

    static {
        log = LoggerFactory.getLogger(SessionByTldListener.class);
        onDemandProducer = new OnDemandStatsProducer("SessionCountByTld", "web", "builtin", (IOnDemandStatsFactory)SessionCountFactory.DEFAULT_INSTANCE);
        ProducerRegistryFactory.getProducerRegistryInstance().registerProducer(onDemandProducer);
    }
}

