/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.web.util;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import net.anotheria.moskito.core.producers.IStatsProducer;
import net.anotheria.moskito.core.registry.NoSuchProducerException;
import net.anotheria.moskito.core.registry.ProducerRegistryAPIFactory;
import net.anotheria.moskito.core.util.session.SessionCountStats;
import net.anotheria.moskito.web.session.SessionCountProducer;
import org.configureme.ConfigurationManager;
import org.configureme.annotations.AfterConfiguration;
import org.configureme.annotations.ConfigureMe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionThrottleFilter
implements Filter {
    public static final String SESSION_SEEN_FLAG = SessionThrottleFilter.class.getName() + "Flag";
    private SessionThrottleFilterConfig throttleConfig;
    private IStatsProducer<SessionCountStats> sessionProducer;
    private static Logger log = LoggerFactory.getLogger(SessionThrottleFilter.class);

    public void init(FilterConfig filterConfig) throws ServletException {
        String configSource = filterConfig.getInitParameter("config");
        if (configSource == null || configSource.length() == 0) {
            configSource = "web.xml";
        }
        if (configSource.equalsIgnoreCase("web.xml")) {
            this.throttleConfig = this.getConfigFromWebXML(filterConfig);
        }
        if (configSource.equalsIgnoreCase("configureme")) {
            this.throttleConfig = this.getConfigFromConfigureMe();
        }
        try {
            this.sessionProducer = new ProducerRegistryAPIFactory().createProducerRegistryAPI().getProducer("SessionCount");
        }
        catch (NoSuchProducerException e) {
            log.error("can't connect to SessionCountProducer, ensure that " + SessionCountProducer.class.getName() + " is declared as listener");
            this.throttleConfig = null;
        }
    }

    private SessionThrottleFilterConfig getConfigFromConfigureMe() {
        SessionThrottleFilterConfig config = new SessionThrottleFilterConfig();
        try {
            ConfigurationManager.INSTANCE.configure((Object)config);
        }
        catch (IllegalArgumentException e) {
            log.warn("Incompatible configuration selected, configureme as source choosen, but sessionthrottle.json is not present");
        }
        return config;
    }

    private SessionThrottleFilterConfig getConfigFromWebXML(FilterConfig filterConfig) {
        int limit = -1;
        String l = filterConfig.getInitParameter("limit");
        try {
            if (l != null) {
                limit = Integer.parseInt(l);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        String target = filterConfig.getInitParameter("redirectTarget");
        if (target == null || target.length() == 0) {
            limit = -1;
        }
        return new SessionThrottleFilterConfig(limit, target);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.throttleConfig == null || this.throttleConfig.getLimit() == -1 || !(request instanceof HttpServletRequest)) {
            chain.doFilter(request, response);
            return;
        }
        HttpSession session = ((HttpServletRequest)request).getSession(false);
        if (session == null || session.getAttribute(SESSION_SEEN_FLAG) == null) {
            if (((SessionCountStats)this.sessionProducer.getStats().get(0)).getCurrentSessionCount(null) > this.throttleConfig.getLimit()) {
                ((HttpServletResponse)response).sendRedirect(this.throttleConfig.getTarget());
                return;
            }
            if (session != null) {
                session.setAttribute(SESSION_SEEN_FLAG, (Object)Boolean.TRUE);
            }
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }

    @ConfigureMe(name="sessionthrottle", allfields=true)
    public static class SessionThrottleFilterConfig {
        private int limit = -1;
        private String target;

        public SessionThrottleFilterConfig() {
        }

        public SessionThrottleFilterConfig(int aLimit, String aTarget) {
            this.limit = aLimit;
            this.target = aTarget;
        }

        public int getLimit() {
            return this.limit;
        }

        public void setLimit(int limit) {
            this.limit = limit;
        }

        public String getTarget() {
            return this.target;
        }

        public void setTarget(String target) {
            this.target = target;
        }

        public String toString() {
            return "limit: " + this.getLimit() + ", Target: " + this.getTarget();
        }

        @AfterConfiguration
        public void logInfo() {
            log.info("Configured session throttle " + this);
        }
    }
}

